VERSION 5.00
Begin VB.Form frmSelExParser 
   Caption         =   "Select External XSL Transformer"
   ClientHeight    =   5760
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6615
   Icon            =   "frmSelExParser.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   5760
   ScaleWidth      =   6615
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame1 
      Caption         =   "Batch File Parameters (must accept 3 parameters -> XML, XSL, and HTML)"
      Height          =   810
      Left            =   435
      TabIndex        =   7
      Top             =   4335
      Width           =   6000
      Begin VB.ComboBox cboParm 
         Height          =   315
         Index           =   2
         Left            =   4200
         TabIndex        =   13
         Top             =   345
         Width           =   1050
      End
      Begin VB.ComboBox cboParm 
         Height          =   315
         Index           =   1
         Left            =   2415
         TabIndex        =   12
         Top             =   345
         Width           =   1050
      End
      Begin VB.ComboBox cboParm 
         Height          =   315
         Index           =   0
         Left            =   630
         TabIndex        =   11
         Top             =   330
         Width           =   1050
      End
      Begin VB.Label Label3 
         Caption         =   "%3 = "
         Height          =   270
         Left            =   3675
         TabIndex        =   10
         Top             =   360
         Width           =   450
      End
      Begin VB.Label Label2 
         Caption         =   "%2 = "
         Height          =   270
         Left            =   1935
         TabIndex        =   9
         Top             =   360
         Width           =   450
      End
      Begin VB.Label Label1 
         Caption         =   "%1 = "
         Height          =   270
         Left            =   210
         TabIndex        =   8
         Top             =   375
         Width           =   450
      End
   End
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   495
      Left            =   435
      TabIndex        =   6
      Top             =   5190
      Width           =   1215
   End
   Begin VB.CommandButton cmdAccept 
      Caption         =   "Accept"
      Default         =   -1  'True
      Height          =   495
      Left            =   5220
      TabIndex        =   5
      Top             =   5190
      Width           =   1215
   End
   Begin VB.DriveListBox Drive1 
      Height          =   315
      Left            =   450
      TabIndex        =   3
      Top             =   375
      Width           =   2985
   End
   Begin VB.TextBox txtTransformer 
      Height          =   285
      Left            =   1560
      TabIndex        =   2
      Top             =   60
      Width           =   4860
   End
   Begin VB.DirListBox Dir1 
      Height          =   3465
      Left            =   435
      TabIndex        =   1
      Top             =   750
      Width           =   3030
   End
   Begin VB.FileListBox File1 
      Height          =   3795
      Left            =   3480
      Pattern         =   "*.bat"
      TabIndex        =   0
      Top             =   405
      Width           =   2940
   End
   Begin VB.Label Label4 
      Caption         =   "Transformer"
      Height          =   240
      Left            =   405
      TabIndex        =   4
      Top             =   75
      Width           =   1035
   End
End
Attribute VB_Name = "frmSelExParser"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private mXMLParmNum As String
Private mXSLParmNum As String
Private mHTMLParmNum As String
Private errMsg As String
Private mBatchFile As String
Public Event TransformerSelected(BatchJob As String, P1 As String, P2 As String, P3 As String)

Private Sub cmdAccept_Click()
   If validRequest Then
      RaiseEvent TransformerSelected(mBatchFile, cboParm(0).Text, cboParm(1).Text, cboParm(2).Text)
      Me.Hide
   Else
      MsgBox errMsg, vbInformation
   End If
End Sub

Private Sub cmdCancel_Click()
   Unload Me
End Sub

Private Sub Dir1_Change()
   Me.File1.Path = Me.Dir1.Path
End Sub

Private Sub Drive1_Change()
   Me.Dir1.Path = Drive1.Drive
End Sub

Private Sub File1_Click()
   Me.txtTransformer.Text = Me.File1.FileName
End Sub

Private Sub Form_Load()
   LoadCombos
End Sub
Private Sub LoadCombos()
   Dim x As Integer
   
   For x = 0 To 2
      With cboParm(x)
         .AddItem ""
         .AddItem "XML"
         .AddItem "XSL"
         .AddItem "HTML"
         .ListIndex = x + 1
      End With
   Next
   
End Sub
Private Function validRequest() As Boolean
   Dim bFile As String
   Dim ParmCol As New Collection
   Dim bFilePath As String
   Dim x As Integer
   
   bFile = Me.txtTransformer.Text
   If InStr(1, bFile, "\") = 0 Then
      bFilePath = Me.Dir1.Path & "\"
   End If
   
   mBatchFile = bFilePath & bFile
   errMsg = ""
   If bFile = "" Or Dir(mBatchFile) = "" Then
      errMsg = "Batch file missing"
   End If
   
   If cboParm(0).Text = "" Or cboParm(1).Text = "" Or cboParm(2).Text = "" Then
      errMsg = errMsg & vbNewLine & "Please select all three parameters"
   End If
   
   On Error Resume Next
   For x = 0 To 2
      ParmCol.Add cboParm(x).Text, cboParm(x).Text
   Next
      
   If ParmCol.Count <> 3 Then
      errMsg = errMsg & vbNewLine & "All three parameters must be unique"
   End If
   
   If errMsg = "" Then
      validRequest = True
   Else
      validRequest = False
   End If
End Function


Public Property Get XMLParmNum() As Variant
   XMLParmNum = mXMLParmNum
End Property

Public Property Let XMLParmNum(ByVal vNewValue As Variant)
   Dim x As Integer
   If Val(vNewValue) > 0 And Val(vNewValue) < 4 Then
      mXMLParmNum = vNewValue
      x = Val(vNewValue)
      Me.cboParm(x - 1).ListIndex = 1
   End If
End Property

Public Property Get XSLParmNum() As Variant
   XSLParmNum = mXSLParmNum
End Property

Public Property Let XSLParmNum(ByVal vNewValue As Variant)
   Dim x As Integer
   If Val(vNewValue) > 0 And Val(vNewValue) < 4 Then
      mXSLParmNum = vNewValue
      x = Val(vNewValue)
      Me.cboParm(x - 1).ListIndex = 2
   End If
End Property

Public Property Get HTMLParmNum() As Variant
   HTMLParmNum = mHTMLParmNum
End Property

Public Property Let HTMLParmNum(ByVal vNewValue As Variant)
   Dim x As Integer
   If Val(vNewValue) > 0 And Val(vNewValue) < 4 Then
      mHTMLParmNum = vNewValue
      x = Val(vNewValue)
      Me.cboParm(x - 1).ListIndex = 3
   End If
End Property

Public Property Get BatchFile() As Variant
   BatchFile = mBatchFile
End Property

Public Property Let BatchFile(ByVal vNewValue As Variant)
   Dim x As Integer
   Dim y As Integer
   
   On Error GoTo ErrHandler
   
   If Dir(vNewValue) = "" Then Exit Property
   
   mBatchFile = vNewValue
   'set directories to match batch file path
   For x = Len(mBatchFile) To 1 Step -1
      If Mid(mBatchFile, x, 1) = "\" Then
         Exit For
      End If
   Next
   
   If x > 0 Then
      y = InStr(1, mBatchFile, ":")
      If y > 1 Then
         Me.Drive1.Drive = Left(mBatchFile, y - 1)
      End If
      Me.Dir1.Path = Left(mBatchFile, x)
      Me.txtTransformer.Text = Mid(mBatchFile, x + 1)
   End If
   Exit Property
ErrHandler:
   MsgBox Err.Description, vbInformation
   
End Property
