<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="html" indent="yes" />
  <xsl:strip-space elements="*" />
  
  <xsl:include href="PopulateTemplate.xsl"/>
  <xsl:include href="CommonPathRef.xsl"/>
  <xsl:include href="AddHeader.xsl"/>      
  <xsl:include href="AddOnTable.xsl"/>
  
  <xsl:param name="DependencyData" select="$RtnDoc/CPYEExplanationStatement" />
  <xsl:param name="depDocTitle">
    <xsl:call-template name="PopulateDisplayName">
    <xsl:with-param name="TargetNode" select="$DependencyData" /></xsl:call-template>  
  </xsl:param> 
  
  <xsl:template name="DependencyTemplate">
    <table id="CPYE" class="styDepTbl" style="margin-top:4mm; font-size:8pt; font-family:Arial">
      <thead class="styTableThead">
        <tr class="styDepTblHdr">
           <th class="styDepTblCell" scope="col">CPYE Credit Amt</th>
           <th class="styDepTblCell" scope="col">CPYE Credit Literal Cd</th>   
            <th class="styDepTblCell" scope="col">CPYE Person Name</th>   
           <th class="styDepTblCell" scope="col">CPYE Social Security Number</th>  
              <th class="styDepTblCell" scope="col">How was  CPYE Credit figured:</th>       
   </tr>
 </thead>  
      <tfoot></tfoot>
      <xsl:for-each select="$DependencyData/CPYEInfo">
      <tbody>  
        <tr>
         <xsl:attribute name="class">
          <xsl:choose>
             <xsl:when test="position() mod 2 = 1">styDepTblRow1</xsl:when>
             <xsl:otherwise>styDepTblRow2</xsl:otherwise>
          </xsl:choose>
          </xsl:attribute>
          <td class="styDepTblCell" style="width:37mm;text-align:right;">
            <xsl:call-template name="PopulateAmount">
            <xsl:with-param name="TargetNode" select="CPYECreditAmt" />
            </xsl:call-template>   
          </td>
          <td class="styDepTblCell" style="width:25mm;text-align:center;">
            <xsl:call-template name="PopulateText">
            <xsl:with-param name="TargetNode" select="CPYECreditLiteralCd" /></xsl:call-template>   
          </td>    
             <td class="styDepTblCell" style="width:50mm;text-align:left;">
              <xsl:call-template name="PopulateText">
                <xsl:with-param name="TargetNode" select="CPYEPersonFullName/PersonFirstName" />            
                   </xsl:call-template> 
                    <span style="width:0.5mm;"/>
                    <xsl:call-template name="PopulateText">
                <xsl:with-param name="TargetNode" select="CPYEPersonFullName/PersonLastName" />
                   </xsl:call-template>  
          </td>  
                <td class="styDepTblCell" style="width:25mm;text-align:center;">
              <xsl:call-template name="PopulateSSN">
                <xsl:with-param name="TargetNode" select="CPYESocialSecurityNumber" />
                   </xsl:call-template>  
          </td>     
          <td class="styDepTblCell" style="width:50mm;text-align:left;">
					<xsl:call-template name="PopulateText">
					<xsl:with-param name="TargetNode" select="HowCPYECreditwasfigured"/>
					</xsl:call-template>
				</td> 
			</tr>
      </tbody>  
          </xsl:for-each>
    </table>
    
  </xsl:template>
     
  <!-- Main template -->
  <xsl:template match="/">
    <html>
      <head>
         <title>
           <!--Other Income Statement-->
          <xsl:value-of select="$depDocTitle" />
        </title>
         <!-- No Browser Caching -->
         <meta http-equiv="Pragma" content="no-cache" />
         <meta http-equiv="Cache-Control" content="no-cache" />
         <meta http-equiv="Expires" content="0" />
         <!-- No Proxy Caching -->
         <meta http-equiv="Cache-Control" content="private" />
         <!-- Define Character Set -->
         <meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />        
         <meta name="Description" content="{$depDocTitle}" />
        
        <script language="JavaScript" src="{$ScriptPath}/FormDisplay.js" type="text/javascript"></script>
        <xsl:call-template name="InitJS"></xsl:call-template>
        <style type="text/css">
          <xsl:if test="not($Print) or $Print=''">
            <xsl:call-template name="AddOnStyle"></xsl:call-template>    
          </xsl:if>
        </style>
      <xsl:call-template name="GlobalStylesDep"/>
</head>
    
      <body class="styBodyClass">    
        <xsl:call-template name="DocumentHeaderDependency">
        </xsl:call-template>       
        <div class="styDepTitleLine">
          <div class="styDepTitle" style="width:187mm">
            <!--TY2008 Other Income Statement-->
            <xsl:value-of select="$depDocTitle" />
          </div>
        </div>        
       
        <xsl:call-template name="PopulateDepCommonLeftover">
        <xsl:with-param name="TargetNode" select="$DependencyData"/>
        </xsl:call-template>                                   
        <xsl:call-template name="DependencyTemplate" />         
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>



