<?xml version="1.0" encoding="UTF-8"?>
<!-- edited with XML Spy v4.4 U (http://www.xmlspy.com) by Ken Dulabhan (Comteq Federal Inc) -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:import href="PopulateTemplate.xsl"/>
	<xsl:include href="CommonPathRef.xsl"/>
	<xsl:include href="AddHeader.xsl"/>
	<xsl:include href="AddOnTable.xsl"/>
	<xsl:include href="IRS8864Style.xsl"/>
	<xsl:output method="html" indent="yes"/>
	<xsl:strip-space elements="*"/>
	<xsl:param name="FormData" select="$RtnDoc/IRS8864"/>
	<xsl:template name="RowWriterCore"/>
	<xsl:template match="/">
		<html lang="EN-US">
			<head>
				<title>
					<xsl:call-template name="FormTitle">
						<xsl:with-param name="RootElement" select="local-name($FormData)"/>
					</xsl:call-template>
				</title>
				<!-- No Browser Caching -->
				<meta http-equiv="Pragma" content="no-cache"/>
				<meta http-equiv="Cache-Control" content="no-cache"/>
				<meta http-equiv="Expires" content="0"/>
				<!-- No Proxy Caching -->
				<meta http-equiv="Cache-Control" content="private"/>
				<!-- Define Character Set -->
				<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"/>
				<meta name="Description" content="TY 2005 IRS Form 8864"/>
				<!-- javascript include -->
				<script language="JavaScript" src="{$ScriptPath}/FormDisplay.js" type="text/javascript"/>
				<xsl:call-template name="InitJS"/>
				<style type="text/css">
					<xsl:if test="not($Print) or $Print=''">
						<xsl:call-template name="IRS8864Style"/>
						<xsl:call-template name="AddOnStyle"/>
				    </xsl:if>
				</style>
				<xsl:call-template name="GlobalStylesForm"/>
			</head>
			<body class="styBodyClass">
				<form name="Form8864" id="Form8864">
					<!-- Standard Warning Lines -->
					<xsl:call-template name="DocumentHeader"/>						
					<!--Begin Form Number and Name-->
					<div class="styBB" style="width:187mm;">					
						<div class="styFNBox" style="width:31mm;height:21.5mm;">
                         Form <span class="styFormNumber">8864</span>
							<br/>
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData"/>
							</xsl:call-template>
							<br/>
							<div style="padding-top:2mm;">
								<span class="styAgency">Department of the Treasury</span>
								<br/>
								<span class="styAgency">Internal Revenue Service</span>
							</div>
						</div>
						<div class="styFTBox" style="width:125mm;height:13mm;">
							<div class="styMainTitle" style="padding-top:1.5mm;">
							  Biodiesel and Renewable Diesel Fuels Credit          
						  </div>
							<br/>
							<div class="styFST" style="height:5mm;font-size:7pt;padding-top:5mm;">
								<img src="{$ImagePath}/8864_Bullet_Line.gif" width="4" height="7" alt="Bullet Image"/>
								  Attach to your tax return.
								 <br/>
								 <img src="{$ImagePath}/8864_Bullet_Line.gif" width="4" height="7" alt="Bullet Image"/>
								 Information about Form 8864 and its instructions is at <a href="http://www.irs.gov/form8864" title="Link to IRS.gov"><i>www.irs.gov/form8864</i></a>.
						  </div>
						</div>
						<!-- This can be taken out later -->
						  <div class="styTYBox" style="width:30mm;height:21.5mm;">
							<div class="styOMB" style="height:2mm;">OMB No. 1545-1924</div>
							<div class="styTY" style="height:7.5mm;font-size:24pt;">
                                20<span class="styTYColor">12</span>
							</div>
							<div class="stySequence">Attachment<br/>Sequence No. <b style="font-size:7.5pt;">141</b>
							</div>
						</div>
					</div>
					<!--  End title of Form  -->
					<!-- Start Name and EIN Line -->
					<div class="styBB" style="width:187mm">
					  <div class="styNameBox" style="width:132mm; height:8mm; font-size:7pt;">Name(s) shown on return
						<br/>
						<xsl:choose>
						  <xsl:when test="$RtnHdrData/ReturnType='1040'">								  
                            <br/>
                            <xsl:call-template name="PopulateReturnHeaderFiler">
                              <xsl:with-param name="TargetNode">Name</xsl:with-param>
                            </xsl:call-template>
                          </xsl:when>
                          <xsl:otherwise>
                            <xsl:call-template name="PopulateReturnHeaderFiler">
                              <xsl:with-param name="TargetNode">BusinessNameLine1</xsl:with-param>
                            </xsl:call-template>
                            <br/>
                            <xsl:call-template name="PopulateReturnHeaderFiler">
                              <xsl:with-param name="TargetNode">BusinessNameLine2</xsl:with-param>
                            </xsl:call-template>
                          </xsl:otherwise>
                        </xsl:choose>
						</div>
						<div class="styEINBox" style="width:50mm;height:4mm;font-size:7pt;padding-left:2mm;"> Identifying number 
                          <br/>
						  <br/>
						  <span style="font-weight:normal;">
							<xsl:choose>
                              <xsl:when test="$RtnHdrData/ReturnType='1040'">
                                <xsl:call-template name="PopulateReturnHeaderFiler">
                                  <xsl:with-param name="TargetNode">PrimarySSN</xsl:with-param>
                                </xsl:call-template>
                              </xsl:when>
                              <xsl:otherwise>
                                <xsl:call-template name="PopulateReturnHeaderFiler">
                                  <xsl:with-param name="TargetNode">EIN</xsl:with-param>
                                </xsl:call-template>
                              </xsl:otherwise>
                            </xsl:choose>
							</span>
						</div>
					</div>
					<!-- end Name and Ein Line -->
					<!-- Start Caution Line -->
					<div class="styBB" style="width: 187mm; font-size: 7pt;padding-top:1mm;">
						<div style="width:187mm;height:6mm;padding-bottom:1mm;">
							<span class="styBoldText" style="vertical-align: top;">Reserved.</span>						
						</div>
					</div>
					<!-- end Caution Line -->
					<!--Table header Begin -->
					<div class="styBB" style="width:188mm;">
						<div class="styNameBox" align="center" style="width:110.75mm;height:11mm;font-size:7pt;text-align:center;padding-top:4mm;">
						  Type of Fuel
						</div>
						<div class="styNameBox" align="center" style="width:32mm;height:11mm;font-size:7pt;text-align: center;padding-top:.5mm;">
							<span class="styBoldText">(a)</span>
							<br/>Number of Gallons <br/>Sold or Used
						</div>
						<div class="styNameBox" align="center" style="width:12mm;height:11mm;font-size:7pt;text-align: center;padding-top:2mm;">
							<span class="styBoldText">(b)</span>
							<br/>Rate      
                         </div>
						<div class="styNameBox" align="center" style="width:33mm;height:11mm;font-size:7pt;border-right-width:0px;text-align: center;padding-top:2mm;">
							<span class="styBoldText">(c)</span>
							<br/>Column (a) x Column (b)</div>
						</div>
					<!--Table header end -->
					<div style="width:187mm;">
					  <div class="styLNLeftNumBoxSD" style="height:4mm;">1</div>
						<div class="styLNDesc" style="width:97.7mm;height:4mm;">
							<span style="float:left;">Reserved</span>
							<!--Dotted Line-->
							<span class="styDotLn" style="float:right;font-weight:bold;padding-right:2mm;">....................</span>
						</div>
						<div class="styLNAmountBox" style="width:5mm;padding-right:1mm;">1</div>
						<div class="styLNAmountBox" style="width:32mm;padding-right:1mm;background-color:lightgrey;border-bottom-color:lightgrey;">
							<!-- Line 1a  -->
							<span style="width:5px;"></span>
						</div>
						<!-- Line 1b  -->
						<div class="styLNAmountBox" style="width:12mm;text-align:center;background-color:lightgrey;border-color:lightgrey;">
		                <span style="width:5px;"></span>
						</div>
						<div class="styLNAmountBox"  style="background-color:lightgrey;border-color:lightgrey;">
<!--							--><!-- Line 1c --><!--
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/BiodieselAmt"/>
								<xsl:with-param name="BackupName">IRS8864BiodieselAfter2008Amount</xsl:with-param>
							</xsl:call-template>-->
						</div>
					</div>
					<div style="width:187mm">
						<div class="styLNLeftNumBoxSD" style="height:4mm;">2</div>
						<div class="styLNDesc" style="width:97.7mm;height:4mm;">
							<span style="float:left">Reserved</span>
							<!--Dotted Line-->
							<span class="styDotLn" style="float:right;font-weight:bold;padding-right:2mm;">....................</span>
						</div>
						<div class="styLNAmountBox" style="width:5mm;padding-right:1mm;">2</div>
						<div class="styLNAmountBox" style="width:32mm;padding-right:1mm;background-color:lightgrey;border-bottom-color:lightgrey;">
							<!-- Line 2a-->
							<span style="width:5px;"></span>
						</div>
						<!-- Line 2b-->
						<div class="styLNAmountBox" style="width:12mm;text-align:center;background-color:lightgrey;border-color:lightgrey;">
                             <span style="width:5px;"></span>
						</div>
						<div class="styLNAmountBox"    style="background-color:lightgrey;border-color:lightgrey;">
<!--						--><!-- Line 2c--><!--
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/AgriBiodieselAmount"/>
								<xsl:with-param name="BackupName">IRS8864AgriBiodieselAmount</xsl:with-param>
							</xsl:call-template>-->
						</div>
					</div>
					<div style="width:187mm">
						<div class="styLNLeftNumBoxSD" style="height:4mm;">3</div>
						<div class="styLNDesc" style="width:97.7mm;height:4mm;">
							<span style="float:left">Reserved</span>
							<!--Dotted Line-->
							<span class="styDotLn" style="float:right;font-weight:bold;padding-right: 2mm;">....................</span>							
						</div>
						<div class="styLNAmountBox" style="width:5mm;padding-right:1mm;">3</div>
						<div class="styLNAmountBox" style="width:32mm;padding-right:1mm;background-color:lightgrey;border-bottom-color:lightgrey;">
						<!-- Line 3a-->
						    <span style="width:5px;"></span>
						</div>
						<!-- Line 3b-->
						<div class="styLNAmountBox" style="width:12mm;text-align:center;background-color:lightgrey;border-color:lightgrey;">
                             <span style="width:5px;"></span>
						</div>
						<div class="styLNAmountBox"    style="background-color:lightgrey;border-color:lightgrey;">
<!--						--><!-- Line 3c--><!--
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/RenewableDieselAmount" />
								<xsl:with-param name="BackupName">IRS8864RenewableDieselAmount</xsl:with-param>
							</xsl:call-template>-->
						</div>
					</div>
					<div style="width:187mm">
						 <div class="styLNLeftNumBoxSD" style="height:4mm;">4</div>
						<div class="styLNDesc" style="width:97.7mm;height:4mm;">
							<span style="float:left">Reserved</span>
							<!--Dotted Line-->
							<span class="styDotLn" style="float:right;font-weight:bold;padding-right: 2mm;">....................</span>
						</div>
						<div class="styLNAmountBox" style="width:5mm;padding-right:1mm;">4</div>
						<div class="styLNAmountBox" style="width:32mm;padding-right:1mm;background-color:lightgrey;border-bottom-color:lightgrey;">
 					 <!-- Line 4a-->
 					     <span style="width:5px;"></span>
						</div>
					<!-- Line 4b-->
						<div class="styLNAmountBox" style="width:12mm;text-align:center;background-color:lightgrey;border-color:lightgrey;">
							<span style="width:5px;"></span>
						</div>
						<div class="styLNAmountBox"   style="background-color:lightgrey;border-color:lightgrey;">
<!--					--><!-- Line 4c--><!--
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/BiodieselMixAmt"/>
								<xsl:with-param name="BackupName">IRS8864BiodieselMixAfter2008Amt</xsl:with-param>
							</xsl:call-template>-->
						</div>
					</div>
					<div style="width:187mm">
						 <div class="styLNLeftNumBoxSD" style="height:4mm;">5</div>
						<div class="styLNDesc" style="width:97.7mm;height:4mm;">
							<span style="float:left">Reserved</span>
							<!--Dotted Line-->
							<span class="styDotLn" style="float:right;font-weight:bold;padding-right: 2mm;">....................</span>
						</div>
						<div class="styLNAmountBox" style="width:5mm;padding-right:1mm;">5</div>
						<div class="styLNAmountBox" style="width:32mm;padding-right:1mm;background-color:lightgrey;border-bottom-color:lightgrey;">
					<!-- Line 5a-->
					     <span style="width:5px;"></span>
						</div>
					<!-- Line 5b-->
						<div class="styLNAmountBox" style="width:12mm;text-align:center;background-color:lightgrey;border-color:lightgrey;">
                             <span style="width:5px;"></span>
						</div>
						<div class="styLNAmountBox"  style="background-color:lightgrey;border-color:lightgrey;">
			<!--		--><!-- Line 5c--><!--
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/AgriBiodieselIncldAmt"/>
								<xsl:with-param name="BackupName">IRS8864AgriBiodieselIncldAmt</xsl:with-param>
							</xsl:call-template>-->
						</div>
					</div>
                    <div style="width:187mm">
 						<div class="styLNLeftNumBoxSD" style="height:4mm;">6</div>
 						    <div class="styLNDesc" style="width:97.7mm;height:4mm;">
							    <span style="float:left">Reserved</span>
								  <!--Dotted Line-->
								<span class="styDotLn" style="float:right;font-weight:bold;padding-right: 2mm;">....................</span>
						    </div>
							<div class="styLNAmountBox" style="width:5mm;padding-right:1mm;">6</div>
							<div class="styLNAmountBox" style="width:32mm;padding-right:1mm;background-color:lightgrey;border-bottom-color:lightgrey;">
							<span style="width:5px;"></span>
						</div>
						<!-- Line 6b-->
						<div class="styLNAmountBox" style="width:12mm;text-align:center;background-color:lightgrey;border-color:lightgrey;">
                                 <span style="width:5px;"></span>
						</div>
						<div class="styLNAmountBox" style="background-color:lightgrey;border-color:lightgrey;">
<!--						--><!-- Line 6c--><!--
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/RenewableDieselInclMixtureAmt"/>
								<xsl:with-param name="BackupName">IRS8864RenewableDieselInclMixtureAmt</xsl:with-param>
							</xsl:call-template>-->
						</div>
					</div>	
					<div style="width:187mm">
					    <div class="styLNLeftNumBoxSD" style="height:4mm;">7</div>
						  <div class="styLNDesc" style="width:97.7mm;height:4mm;">
							<span style="float:left">Reserved</span>
							<!--Dotted Line-->
							<span class="styDotLn" style="float:right;font-weight:bold;padding-right: 2mm;">....................</span>
						  </div>
						  <div class="styLNAmountBox" style="width:5mm;padding-right:1mm;">7</div>
						  <div class="styLNAmountBox" style="width:32mm;padding-right:1mm;background-color:lightgrey;">
						  <span style="width:5px;"></span>
					    </div>
						<!-- Line 7b-->
						<div class="styLNAmountBox" style="width:12mm;text-align:center;background-color:lightgrey;border-color:lightgrey;border-bottom-color:#000000;">
							<span style="width:5px;"></span>
						</div>
						<div class="styLNAmountBox" style="background-color:lightgrey;border-color:lightgrey;border-bottom-color:#000000;">
<!--						--><!-- Line 7c--><!--
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/QualifiedAgriBioDieselProdAmt"/>
								<xsl:with-param name="BackupName">IRS8864QualifiedAgriBioDieselProd</xsl:with-param>
							</xsl:call-template>-->
						</div>
					</div>
					<div style="width:187mm">
					  <div class="styLNLeftNumBoxSD" style="height:4mm;">8</div>
						<div class="styLNDesc" style="width:138.75mm;height:4mm;font-size:2.5mm;">
							<span style="float:left">Reserved</span>
							<!--Dotted Line-->
							<span class="styDotLn" style="float:right;font-weight:bold;padding-right: 2mm;">..............................</span>
						</div>
						<div class="styLNRightNumBox">8</div>
						  <div class="styLNAmountBox" style="background-color:lightgrey;">
						</div>
					</div>
					<div style="width:187mm">
					  <div class="styLNLeftNumBoxSD" style="height:4mm;">9</div>
						<div class="styLNDesc" style="width:138.75mm;height:4mm;font-size:2.5mm;">
							<span style="float:left">Biodiesel and renewable diesel fuels credit from partnerships, S corporations, cooperatives, estates, and </span>
						</div>
						<div class="styLNAmountBox" style="border-bottom-width:0px;width:8mm;padding-right:2mm;"/>
						   <div class="styLNAmountBox" style="width:30mm;border-bottom-width:0px;"/>
					    </div>
					    <div style="width:187mm">
						  <div class="styLNLeftNumBox" style="height:4mm;padding-bottom:.5mm;"/>
						    <div class="styLNDesc" style="width:138.75mm;height:4mm;">
							  <span style="float:left">trusts (see instructions)</span>
							   <!--Dotted Line-->
							  <span class="styDotLn" style="float:right;font-weight:bold;padding-right: 2mm;">..........................</span>
						    </div>
						<!-- Line 9-->
						<div class="styLNRightNumBox">9</div>
						  <div class="styLNAmountBox">
							<xsl:call-template name="PopulateAmount">
							<xsl:with-param name="TargetNode" select="$FormData/BiodieselRenewableFuelsAmounts" />       
							<xsl:with-param name="BackupName">IRS8864BiodieselRenewableFuelsAmounts</xsl:with-param>
							</xsl:call-template>
						</div>
					</div>
					<div style="width:187mm">
					  <div class="styLNLeftNumBox" style="height:4mm;">10</div>
						<div class="styLNDesc" style="width:138.75mm;height:4mm;font-size:2.5mm;">
							<span style="float:left">Add lines 8 and 9. Cooperatives, estates, and trusts, go to line 11. Partnership and S corporations, </span>
						</div>
						<div class="styLNAmountBox" style="border-bottom-width:0px;width:8mm;padding-right:2mm;"/>
						  <div class="styLNAmountBox" style="width:30mm;border-bottom-width:0px;"/>
					</div>
					<div style="width:187mm">
					  <div class="styLNLeftNumBox" style="height:4mm;padding-bottom:.5mm;"/>
						<div class="styLNDesc" style="width:138.75mm;height:4mm;">
							<span style="float:left">report this amount on Schedule K. All others, report this amount on Form 3800, line 1l </span>
							<!--Dotted Line-->
							<span class="styDotLn" style="float:right;font-weight:bold;padding-right: 2mm;">.....</span>
						</div>
						<div class="styLNRightNumBox">10</div>
						  <div class="styLNAmountBox">
						<!-- Line 10-->
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/AddLines8and9Amt"/>
								<xsl:with-param name="BackupName">IRS8864AddLines8and9Amt</xsl:with-param>
							</xsl:call-template>
						</div>
					</div>
					<div style="width:187mm">
					  <div class="styLNLeftNumBox" style="height:4mm;">11</div>
						<div class="styLNDesc" style="width:138.75mm;height:4mm;font-size:2.5mm;">
							<span style="float:left">Amount allocated to patrons of the cooperative or beneficiaries of the estate or trust (see instructions)</span>
							<!--Dotted Line-->
					        <span class="styDotLn" style="float:right;font-weight:bold;padding-right: 1mm;"></span>
						</div>
						<div class="styLNRightNumBox">11</div>
						  <div class="styLNAmountBox">
						    <!-- Line 11-->
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/AllocatedToBeneficiariesAmt"/>
								<xsl:with-param name="BackupName">IRS8864AllocatedToBeneficiariesAmt</xsl:with-param>
							</xsl:call-template>
						</div>
					</div>
					<div style="width:187mm">
					  <div class="styLNLeftNumBox" style="height:4mm;">12</div>
						<div class="styLNDesc" style="width:138.75mm;height:4mm;font-size:2.5mm;">
							<span style="float:left">Cooperatives, estates, and trusts, subtract line 11 from line 10. Report this amount on Form 3800, </span>
						</div>
						<div class="styLNAmountBox" style="border-bottom-width:0px;width:8mm;padding-right:2mm;"/>
						  <div class="styLNAmountBox" style="width:30mm;border-bottom-width:0px;"/>
					    </div>
					    <div class="styBB" style="width:187mm">
						  <div class="styLNLeftNumBox" style="height:4mm;padding-bottom:.5mm;"/>
						    <div class="styLNDesc" style="width:138.75mm;height:4mm;">
							  <span style="float:left">line 1l  </span>
							  <!--Dotted Line-->
							  <span class="styDotLn" style="float:right;font-weight:bold;padding-right: 2mm;">...............................</span>
						    </div>
						 <div class="styLNRightNumBoxNBB">12</div>
						   <div class="styLNAmountBoxNBB">
							<!-- Line 12-->
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/EstatesTrustsAndCoopsCreditAmt"/>
								<xsl:with-param name="BackupName">IRS8864EstatesTrustsAndCoopsCreditAmt</xsl:with-param>
							</xsl:call-template>							
						   </div>
					    </div>
					<!--Start Page Footer -->
					<div style="width:187mm;font-size:8pt;border-top-width:1px">
						<div class="stySmallText" style="font-weight:bold; float:left; padding-top:0.5mm">
						  For Paperwork Reduction Act Notice,  see instructions.
                        </div>
						<div style="float:right">
							<span style="margin-right:32mm; font-size:7pt">Cat. No. 25778F</span>Form <b>8864</b> (2012)
                        </div>
					</div>
					<p style="page-break-before:always"/>
					<!-- end Page Footer -->
					<!-- start ADDITIONAL DATA SECTION-->
					<div class="styLeftOverTitleLine" id="LeftoverData" style="font-family:verdana, arial, sans-serif">
						<div class="styLeftOverTitle">
          Additional Data        
          </div>
						<div class="styLeftOverButtonContainer">
							<input class="styLeftoverTableBtn" type="button" value="Return to Form" onclick="javascript:returnToWriteInImage()" tabindex="1"/>
						</div>
					</div>
					<table class="styLeftOverTbl">
						<xsl:call-template name="PopulateCommonLeftover">
							<xsl:with-param name="TargetNode" select="$FormData"/>
						</xsl:call-template>
					</table>
				</form>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
