<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:output method="html" indent="yes" />
  <xsl:strip-space elements="*" />  
  <xsl:include href="PopulateTemplate.xsl"/>
  <xsl:include href="CommonPathRef.xsl"/>
  <xsl:include href="AddHeader.xsl"/>
  <xsl:include href="AddOnTable.xsl"/>
  <xsl:param name="DependencyData" select="$RtnDoc/QlfyDivRcvdByCorpPrtnrSec243" />
  <xsl:template name="DependencyTemplate">
    <table id="QDRBCPS243Tbl" class="styDepTbl">
      <tr  class="styDepTblRow1">
        <th class="styDepTblCell" scope="row" style="text-align:right;width:100mm;">
          Filer's Name
        </th>
        <td class="styDepTblCell" style="text-align:left;width:80mm;">
          <xsl:call-template name="PopulateText">
            <xsl:with-param name="TargetNode" select="$DependencyData/Name/BusinessNameLine1" />
          </xsl:call-template><span style="width:2mm;"></span>
          <xsl:if test="$DependencyData/Name/BusinessNameLine2 != ''">
          <xsl:call-template name="PopulateText">
                <xsl:with-param name="TargetNode" select="$DependencyData/Name/BusinessNameLine2" />
              </xsl:call-template>
          </xsl:if>          
        </td>
      </tr>
      <tr  class="styDepTblRow2">
        <th class="styDepTblCell" scope="row" style="text-align:right;width:100mm;">
          Filer's EIN
        </th>
        <td class="styDepTblCell" style="text-align:center;width:80mm;">
        <xsl:call-template name="PopulateEIN">
        <xsl:with-param name="TargetNode" select="$DependencyData/EIN"/>
          </xsl:call-template>  
         </td>
      </tr>
       <tr  class="styDepTblRow1">
        <th class="styDepTblCell" scope="row" style="text-align:right;width:100mm;">
         Amount of Qualified Dividends Issued to a Corporate Partner Under Section 243
        </th>
        <td class="styDepTblCell" style="text-align:right;width:80mm;padding-top:5mm;">
<xsl:call-template name="PopulateAmount">
               <xsl:with-param name="TargetNode" select="$DependencyData/Section243QualifiedDividends"/>
               </xsl:call-template>  
         </td>
      </tr>
  </table>
  </xsl:template>  
  <!-- Main template -->
  <xsl:param name="depDocTitle">
    <xsl:call-template name="PopulateDisplayName"><xsl:with-param name="TargetNode" select="$DependencyData" /></xsl:call-template>  
  </xsl:param>
  <!-- Main template -->
  <xsl:template match="/" >

    <html>
      <head>
           <title><xsl:value-of select="$depDocTitle" /></title>
         <!-- No Browser Caching -->
         <meta http-equiv="Pragma" content="no-cache" />
         <meta http-equiv="Cache-Control" content="no-cache" />
         <meta http-equiv="Expires" content="0" />
         <!-- No Proxy Caching -->
         <meta http-equiv="Cache-Control" content="private" />
         <!-- Define Character Set -->
         <meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />        
         <meta name="Description" content="{$depDocTitle}" />
         <script language="JavaScript" src="{$ScriptPath}/FormDisplay.js"></script>
        <xsl:call-template name="InitJS"></xsl:call-template>      
        <style type="text/css">
        </style>
        <style type="text/css">
  <xsl:if test="not($Print) or $Print=''">
    <xsl:call-template name="AddOnStyle"></xsl:call-template>    
  </xsl:if>
</style>
      <xsl:call-template name="GlobalStylesDep"/>
</head>    
      <body class="styBodyClass">
        <xsl:call-template name="DocumentHeaderDependency"  />  
        <div class="styDepTitleLine">
          <span class="styDepTitle">
            <span style="width:175mm;"><xsl:value-of select="$depDocTitle" /></span>    
          </span>
        </div>
        <xsl:call-template name="PopulateDepCommonLeftover"><xsl:with-param name="TargetNode" select="$DependencyData"/></xsl:call-template>
        <span style="height:5px;"></span>
        <!-- Transform Itemized Other Income Schedule -->
        <xsl:call-template name="DependencyTemplate" />
        <br />
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>







