VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "DisplayNames"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Collection" ,"DocumentDisplayName"
Attribute VB_Ext_KEY = "Member0" ,"DocumentDisplayName"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit

'local variable to hold collection
Private mCol As Collection

Public Function Add(mDocumentDisplayName As DocumentDisplayName, Optional sKey As String) As DocumentDisplayName

    If Len(sKey) = 0 Then
        mCol.Add mDocumentDisplayName
    Else
        mCol.Add mDocumentDisplayName, sKey
    End If
    
    Set Add = mDocumentDisplayName

End Function

Public Property Get Item(vntIndexKey As Variant) As DocumentDisplayName
Attribute Item.VB_UserMemId = 0
    'used when referencing an element in the collection
    'vntIndexKey contains either the Index or Key to the collection,
    'this is why it is declared as a Variant
    'Syntax: Set foo = x.Item(xyz) or Set foo = x.Item(5)
    On Error Resume Next
  Set Item = mCol(vntIndexKey)
End Property



Public Property Get Count() As Long
    'used when retrieving the number of elements in the
    'collection. Syntax: Debug.Print x.Count
    Count = mCol.Count
End Property


Public Sub Remove(vntIndexKey As Variant)
    'used when removing an element from the collection
    'vntIndexKey contains either the Index or Key, which is why
    'it is declared as a Variant
    'Syntax: x.Remove(xyz)


    mCol.Remove vntIndexKey
End Sub


Public Property Get NewEnum() As IUnknown
Attribute NewEnum.VB_UserMemId = -4
Attribute NewEnum.VB_MemberFlags = "40"
    'this property allows you to enumerate
    'this collection with the For...Each syntax
    Set NewEnum = mCol.[_NewEnum]
End Property


Private Sub Class_Initialize()
    'creates the collection when this class is created
    Set mCol = New Collection
End Sub


Private Sub Class_Terminate()
    'destroys collection when this class is terminated
    Set mCol = Nothing
End Sub


Public Sub LoadDisplayNames()
   Dim DocXrefList As New MSXML2.DOMDocument
   Dim FileName As String
   Dim x As Integer
   Dim y As Integer
   Dim DocDisplay As DocumentDisplayName
   Dim nList As IXMLDOMNodeList
   Dim RootName As String
   Dim DisplayName As String
   
   On Error Resume Next
   
   FileName = App.Path & "\DocXrefList.xml"
   
   If Dir(FileName) = "" Then
      MsgBox "Display name xml (" & FileName & ") not found" & vbNewLine & _
      "Please make sure you've copied DocXrefList.xml to the directory where this program resides.", vbInformation
      Exit Sub
   End If
   
   DocXrefList.Load FileName
   If DocXrefList.parseError.errorCode <> 0 Then
      MsgBox DocXrefList.parseError.reason, vbInformation
      Exit Sub
   End If
   
   Set nList = DocXrefList.getElementsByTagName("ReturnDoc")
   For x = 0 To nList.length - 1
      RootName = ""
      DisplayName = ""
      For y = 0 To nList.Item(x).childNodes.length - 1
         If nList.Item(x).childNodes(y).NodeName = "ReturnDocumentRootName" Then
            RootName = nList.Item(x).childNodes(y).Text
         End If
         If nList.Item(x).childNodes(y).NodeName = "DisplayName" Then
            DisplayName = nList.Item(x).childNodes(y).Text
         End If
      Next
      Set DocDisplay = New DocumentDisplayName
      DocDisplay.DisplayName = DisplayName
      DocDisplay.ReturnDocumentRootName = RootName
      DocDisplay.Key = RootName
      mCol.Add DocDisplay, RootName
      Set DocDisplay = Nothing
   Next
   
'   MsgBox "Found " & mCol.Count & " items.", vbInformation
   
End Sub
