VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsLog"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Option Explicit

Private fn As Integer
Private mLogIt As Boolean
Private mLogFileName As String
Private mTimeStampIT As Boolean
Private mLogOpen As Boolean
Private mAppend As Boolean
Private mCloseEveryTime As Boolean
Public Sub LogClose()
   If mLogOpen Then
      CloseLog
   End If
End Sub


Public Function Log(ProgEvent As String)
   On Error GoTo ErrHandler
   If Not mLogOpen Then
      OpenLog
   End If
   If mCloseEveryTime Then
      mAppend = True
      CloseLog
      OpenLog
   End If
   If mLogIt Then
      If mTimeStampIT Then
         Print #fn, Now & " " & ProgEvent
      Else
         Print #fn, ProgEvent
      End If
   End If
   
   Exit Function

ErrHandler:
   Debug.Print "Unable to log " & ProgEvent
   Exit Function
End Function

Private Sub Class_Initialize()
   mLogOpen = False
End Sub

Private Sub Class_Terminate()
   If mLogOpen Then
      Close #fn
   End If
End Sub

Public Property Get LogIT() As Variant
   LogIT = mLogIt
End Property

Public Property Let LogIT(ByVal vNewValue As Variant)
   mLogIt = vNewValue
End Property

Public Property Get LogFileName() As Variant
   LogFileName = mLogFileName
End Property

Public Property Let LogFileName(ByVal vNewValue As Variant)
   mLogFileName = vNewValue
   If Not mLogOpen Then
      OpenLog
   End If
End Property

Public Property Get TimeStampIT() As Variant
   TimeStampIT = mTimeStampIT
End Property

Public Property Let TimeStampIT(ByVal vNewValue As Variant)
   mTimeStampIT = vNewValue
End Property
Private Sub OpenLog()
   
   If mLogOpen Then
      Exit Sub
   End If

   fn = FreeFile
   If mLogFileName = "" Then
      mLogFileName = "log.txt"
   End If
   If mAppend Then
      Open mLogFileName For Append As #fn
   Else
      Open mLogFileName For Output As #fn
   End If
   
   mLogOpen = True
   
End Sub
Public Sub PrintVersion()

   If Not mLogOpen Then
      OpenLog
   End If
   
   Print #fn, App.EXEName & " Version " & App.Major & _
      "." & App.Minor & "." & App.Revision
      
End Sub
Private Sub CloseLog()
   
   If Not mLogOpen Then
      Exit Sub
   End If
      
   Close #fn
   
   mLogOpen = False
   
End Sub


Public Property Get Append() As Variant
   Append = mAppend
End Property

Public Property Let Append(ByVal vNewValue As Variant)
   If vNewValue = True Or vNewValue = False Then
      mAppend = vNewValue
   End If
End Property

Public Property Get CloseEveryTime() As Variant
   CloseEveryTime = mCloseEveryTime
End Property

Public Property Let CloseEveryTime(ByVal vNewValue As Variant)
   If TypeName(vNewValue) = "Boolean" Then
      mCloseEveryTime = vNewValue
   End If
End Property
