VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "ComDlg32.OCX"
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form frmFlattenXSD 
   Caption         =   "Extract XSD element properties"
   ClientHeight    =   3195
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   5610
   LinkTopic       =   "Form1"
   ScaleHeight     =   3195
   ScaleWidth      =   5610
   StartUpPosition =   3  'Windows Default
   Begin MSComctlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   285
      Left            =   0
      TabIndex        =   8
      Top             =   2910
      Width           =   5610
      _ExtentX        =   9895
      _ExtentY        =   503
      Style           =   1
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   1
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
         EndProperty
      EndProperty
   End
   Begin VB.CheckBox chkExAll 
      Caption         =   "Extract XML for entire XSD directory"
      Height          =   210
      Left            =   1260
      TabIndex        =   7
      Top             =   1230
      Width           =   3570
   End
   Begin MSComDlg.CommonDialog CommonDialog2 
      Left            =   2835
      Top             =   2415
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.CommandButton cmdGetEssentials 
      Caption         =   "Get &Essentials"
      Height          =   495
      Left            =   4230
      TabIndex        =   6
      Top             =   1725
      Width           =   1215
   End
   Begin VB.TextBox txtXML 
      Height          =   285
      Left            =   1260
      TabIndex        =   4
      Top             =   705
      Width           =   3585
   End
   Begin VB.CommandButton cmdPickXML 
      Caption         =   "..."
      Height          =   285
      Left            =   4935
      TabIndex        =   3
      Top             =   705
      Width           =   480
   End
   Begin VB.CommandButton cmdSetInput 
      Caption         =   "..."
      Height          =   285
      Left            =   4935
      TabIndex        =   2
      Top             =   315
      Width           =   480
   End
   Begin VB.TextBox txtInput 
      Height          =   285
      Left            =   1245
      TabIndex        =   1
      Top             =   330
      Width           =   3585
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   3735
      Top             =   2445
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Label Label2 
      Caption         =   $"frmFlattenXSD.frx":0000
      Height          =   1050
      Left            =   90
      TabIndex        =   9
      Top             =   1620
      Width           =   4110
   End
   Begin VB.Label Label3 
      Alignment       =   1  'Right Justify
      Caption         =   "XML"
      Height          =   240
      Left            =   255
      TabIndex        =   5
      Top             =   705
      Width           =   885
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "XSD"
      Height          =   240
      Left            =   240
      TabIndex        =   0
      Top             =   330
      Width           =   885
   End
End
Attribute VB_Name = "frmFlattenXSD"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private XSDDoc As MSXML2.DOMDocument
Private FlatXSDDoc As MSXML2.DOMDocument
Private EssentialEltDoc As MSXML2.DOMDocument
Private eFileTypesDoc As MSXML2.DOMDocument
Public XSDDir As String
Public XSDExDir As String
Private ExtNode As IXMLDOMElement
Private mEltDescripts As EltDiscriptors
Private CancelJob As Boolean
Private Sub cmdGetEssentials_Click()
   Dim XtractDir As String
   
   'build a flattened XSD
      'clone input xsd
      'remove all nodes but "root" element (from clone)
      'walk nodes of clone, replacing referenced "type" and "group"
      '  with actual nodes of the type or group
      'save the flattened XSD
   If Me.cmdGetEssentials.Caption = "Cancel" Then
      CancelJob = True
      Exit Sub
   Else
      CancelJob = False
   End If
      
   Screen.MousePointer = vbHourglass
   
   If Me.chkExAll.Value = vbChecked Then
      'XtractDir = Path(Me.txtInput.Text)
      ExtractAllEssentials XSDExDir
   Else
      '1) clone the input xsd
      CloneInput
      '2) remove all but root, annotation and includes
      RemoveExtraNodes
      '3) expand nodes
      ExpandNodes
      '4) extract essentials using cloned xsd
      ExtractEssentials
      If Me.txtXML.Text <> "" Then
         EssentialEltDoc.save Me.txtXML.Text
      End If
   End If
   
   Screen.MousePointer = vbNormal
   

End Sub

Private Sub cmdGo_Click()
   'build a flattened XSD
      'clone input xsd
      'remove all nodes but "root" element (from clone)
      'walk nodes of clone, replacing referenced "type" and "group"
      '  with actual nodes of the type or group
      'save the flattened XSD
      
   Screen.MousePointer = vbHourglass
   '1) clone the input xsd
   CloneInput
   '2) remove all but root, annotation and includes
   RemoveExtraNodes
   '2) expand nodes
   ExpandNodes
   
   Screen.MousePointer = vbNormal
   
End Sub

Private Sub cmdPickXML_Click()
   Dim cDLG As New clsDialog
   Dim fName As String
   
   Me.CommonDialog2.InitDir = XSDExDir
   If Me.chkExAll.Value = vbChecked Then
      fName = cDLG.GetDirectory(Me.CommonDialog2, "Select XSD extract directory", "*.xml|*.xml|*.*|*.*", "open")
   Else
      fName = cDLG.GetFile(Me.CommonDialog2, "*.xml|*.xml", "save")
   End If
   
   If fName <> "" Then
      Me.txtXML.Text = fName
   End If
   XSDExDir = Path(fName)
   Set cDLG = Nothing

End Sub

Private Sub cmdSetInput_Click()
   Dim cDLG As New clsDialog
   Dim fName As String
   
   Me.CommonDialog1.InitDir = XSDDir
   fName = cDLG.GetFile2Open(Me.CommonDialog1, "*.xsd|*.xsd")
   If fName = "" Then
      Set cDLG = Nothing
      Exit Sub
   End If
   
   Me.txtInput.Text = fName
   XSDDir = Path(fName)
   Set cDLG = Nothing
   
   On Error Resume Next
   Set XSDDoc = New MSXML2.DOMDocument
   XSDDoc.resolveExternals = True
   XSDDoc.Load fName
   If XSDDoc.parseError.errorCode <> 0 Then
      MsgBox XSDDoc.parseError.reason, vbInformation
   End If
   
End Sub

'Private Sub cmdSetOutput_Click()
'   Dim cDLG As New clsDialog
'   Dim fName As String
'   fName = cDLG.GetFile(Me.CommonDialog1, "*.xsd|*.xsd", "save")
'   If fName <> "" Then
'      Me.txtOutput.Text = fName
'   End If
'   Set cDLG = Nothing
'
'End Sub
Private Sub CloneInput()
   Dim tNode As IXMLDOMNode
   Dim PI As IXMLDOMProcessingInstruction
   
   Set FlatXSDDoc = New MSXML2.DOMDocument
   Set tNode = XSDDoc.documentElement.cloneNode(True)
   Set PI = FlatXSDDoc.createProcessingInstruction("xml", "version='1.0'")
   FlatXSDDoc.appendChild PI
   FlatXSDDoc.appendChild tNode
   
End Sub

Private Sub ExpandNodes()
   Dim x As Integer
   Dim E As IXMLDOMElement
   Dim FoundElt As Boolean
   With FlatXSDDoc.documentElement.childNodes
      For x = 0 To .length - 1
         If .Item(x).NodeName = "xsd:element" Then
            Exit For
         End If
      Next
      If x = .length Then
         FoundElt = False
      Else
         FoundElt = True
         Set E = .Item(x)
      End If
   End With
   
   If FoundElt Then
      ExpandNode E
   End If
End Sub
Private Sub ExpandNode(E As IXMLDOMElement)
   Dim x As Integer
   Dim EltType As String
   Dim EltGroup As String
   Dim SubE As IXMLDOMElement
   Dim TypeName As String
   Dim Found As Boolean
   Dim IsExt As Boolean
   Dim ExSubE As IXMLDOMElement
   Dim ExElt As IXMLDOMElement
   Dim ExParent As IXMLDOMElement
   Dim EltName As String
   
   IsExt = False
   EltType = getAttribVal(E, "type")
   If EltType = "" Then
      EltType = XsdExtensionBase(E)
      If EltType <> "" Then
         IsExt = True
      End If
   End If
   
'   Debug.Assert EltType <> "StockHoldingChangesForTaxYearType"
   
   If Left(EltType, 4) = "xsd:" Then
      'its a w3 XSD type
      Exit Sub
   End If
   
   EltGroup = ""
   If E.NodeName = "xsd:group" Then
      EltGroup = getAttribVal(E, "ref")
      If EltGroup <> "" Then
         ExpandGroup E, EltGroup
         Exit Sub
      End If
      
   End If
   
   If E.NodeName = "xsd:element" Then
      For x = 0 To E.Attributes.length - 1
         If E.Attributes(x).NodeName = "name" Then
            EltName = E.Attributes(x).Text
'            Debug.Assert EltName <> "SubsidiaryCorporationInfo"
            Exit For
         End If
      Next
'      Debug.Assert EltName <> "MedicareMedicaidPayments"
   End If

   'look for definition of type within the document
   If EltType <> "" Then
      With XSDDoc.documentElement.childNodes
         For x = 0 To .length - 1
   '         Debug.Print .Item(x).NodeName
            If .Item(x).nodeType = NODE_ELEMENT Then
               Set SubE = .Item(x)
               If SubE.NodeName = "xsd:complexType" Or _
                  SubE.NodeName = "xsd:simpleType" Then
                  TypeName = getAttribVal(SubE, "name")
                  If TypeName = "" Then
                     TypeName = XsdExtensionBase(SubE)
                  End If
                  If TypeName = EltType Then
                     Found = True
                     Exit For
                  End If
               End If
            End If
         Next
      End With
      If Not Found Then
         'look in efileTypes.xsd
   '      Debug.Print Now & " looking in efiletypes"
         With eFileTypesDoc.documentElement.childNodes
            For x = 0 To .length - 1
               If .Item(x).nodeType = NODE_ELEMENT Then
                  Set SubE = .Item(x)
                  If SubE.NodeName = "xsd:complexType" Or _
                     SubE.NodeName = "xsd:simpleType" Then
                     TypeName = getAttribVal(SubE, "name")
                     If TypeName = "" Then
                        TypeName = XsdExtensionBase(SubE)
                     End If
                     If TypeName = EltType Then
                        If SubE.NodeName = "xsd:complexType" Then
                           Found = True
                        End If
                        Exit For
                     End If
                  End If
               End If
            Next
         End With
   '      Debug.Print Now & " finished looking"
   '      Debug.Print ""
      End If
      If Found Then  'expand node by inserting type definition
         If IsExt Then
            'copy the sub nodes of "xsd:extension", then remove the "xsd:extension" node
            Set ExElt = ExtensionNode(E)
            On Error Resume Next
            If ExElt.NodeName <> "" Then Found = True
            If Err.Number = 0 Then  'check to see if obj is set
               Set ExParent = ExElt.parentNode
               ExParent.removeChild ExElt
               'add the sub nodes
               For x = 0 To ExtNode.childNodes.length - 1
                  ExParent.appendChild ExtNode.childNodes(x).cloneNode(True)
               Next
'               For x = 0 To SubE.childNodes.length - 1
'                  ExParent.appendChild SubE.childNodes(x).cloneNode(True)
'               Next
            End If
         Else
            If SubE.childNodes.length > 0 Then
               'remove the type attribute
               For x = 0 To E.Attributes.length - 1
                  If E.Attributes(x).NodeName = "type" Then
                     E.Attributes.removeNamedItem "type"
                     Exit For
                  End If
               Next
            End If
         End If
         'append children of SubE
         If InStr(1, SubE.XML, "xsd:group") > 0 Then
            ExpandSubGroups SubE
         End If
         For x = 0 To SubE.childNodes.length - 1
            E.appendChild SubE.childNodes(x).cloneNode(True)
         Next
      End If
   End If
   
   'expand sub nodes
   If E.nodeType = NODE_ELEMENT Then
      If E.childNodes.length > 0 Then
         For x = 0 To E.childNodes.length - 1
            If E.childNodes(x).nodeType = NODE_ELEMENT Then
               Set SubE = E.childNodes(x)
               If SubE.nodeType = NODE_ELEMENT Then
                  If SubE.NodeName <> "xsd:annotation" Then
                     ExpandNode SubE
                  End If
               End If
            End If
         Next
      End If
   End If
   
End Sub
Private Function getAttribVal(Elt As IXMLDOMElement, AttribName As String) As String
   Dim x As Integer
   
   For x = 0 To Elt.Attributes.length - 1
      If Elt.Attributes(x).NodeName = AttribName Then
         getAttribVal = Elt.Attributes(x).Text
         Exit For
      End If
   Next
   
End Function

Private Function XsdExtensionBase(XsdNode As IXMLDOMNode) As String
   Dim x As Integer
   Dim y As Integer
   Dim ExtBase As String
   Dim EltType As String
   Dim E As IXMLDOMElement
   
   For x = 0 To XsdNode.childNodes.length - 1
      If XsdNode.childNodes.length > 0 And XsdNode.childNodes(x).NodeName <> "xsd:extension" Then
         If XsdNode.childNodes(x).nodeType = NODE_ELEMENT Then
            Set E = XsdNode.childNodes(x)
            EltType = getAttribVal(E, "base")
            If EltType <> "" Then
               XsdExtensionBase = EltType
               Set ExtNode = E
               Exit Function
            End If
         End If
         If XsdNode.childNodes(x).NodeName <> "xsd:attributeGroup" And _
          XsdNode.childNodes(x).NodeName <> "xsd:attribute" And _
          XsdNode.childNodes(x).NodeName <> "xsd:element" Then
            ExtBase = XsdExtensionBase(XsdNode.childNodes(x))
         End If
         If ExtBase <> "" Then
            XsdExtensionBase = ExtBase
            Exit Function
         End If
      Else
         If XsdNode.childNodes(x).NodeName = "xsd:extension" Or _
          XsdNode.childNodes(x).NodeName = "xsd:restriction" Then
            'look for "base" attribute
            For y = 0 To XsdNode.childNodes(x).Attributes.length - 1
               If XsdNode.childNodes(x).Attributes(y).NodeName = "base" Then
                  XsdExtensionBase = XsdNode.childNodes(x).Attributes(y).Text
                  Set ExtNode = XsdNode.childNodes(x)
               End If
            Next
            Exit Function
         End If
      End If
   Next
   
End Function
Private Sub LoadEfileTypes()
   On Error GoTo ErrHandler
   Dim eTypFile As String
   
   Set eFileTypesDoc = New MSXML2.DOMDocument
   eTypFile = XSDDir & "efileTypes.xsd"
   If Dir(eTypFile) = "" Then
      MsgBox "Couldn't find " & eTypFile, vbInformation
      Exit Sub
   End If
   
   eFileTypesDoc.Load eTypFile
   
'   LoadETypeXSDElts
   
   Exit Sub
   
ErrHandler:
   If eFileTypesDoc.parseError.errorCode <> 0 Then
      MsgBox eFileTypesDoc.parseError.reason, vbInformation
   Else
      MsgBox Err.Description, vbInformation
   End If
   Resume Next
   Resume
End Sub

Private Sub Form_Load()
   Dim args As String
   Dim x As Integer
   Dim y As Integer
   Dim z As Integer
   Dim GetAllEssentials As Boolean
   Dim XtractDir As String
   
   XSDDir = "D:\mef\Schemas\2006Combined\d1\d2\XSD\"
   LoadEfileTypes
      
   args = Command()
   x = InStr(1, UCase(args), "/ALL ")    ' converts "/i" to "/I" before comparison
   If x > 0 Then
      GetAllEssentials = True
      args = Mid(args, x + 5)
   End If
   
   x = InStr(1, UCase(args), "/XSD_DIR:")
   If x > 0 Then
      y = x + Len("/XSD_dir:")
      z = InStr(y, args, " ")
      If z = 0 Then z = Len(args)
      XSDDir = Mid(args, y, z - y + 1)
      If x = 1 Then
         args = Mid(args, y)
      Else
         args = Left(args, x - 1) & Mid(args, y)
      End If
      CommonDialog1.InitDir = XSDDir
   End If

   x = InStr(1, UCase(args), "/XTRACT_DIR:")
   If x > 0 Then
      y = x + Len("/Xtract_dir:")
      z = InStr(y, args, " ")
      If z = 0 Then z = Len(args)
      XtractDir = Mid(args, y, z - y + 1)
      If x = 1 Then
         args = Mid(args, y)
      Else
         args = Left(args, x - 1) & Mid(args, y)
      End If
      If Dir(XtractDir, vbDirectory) = "" Then
         MkDir XtractDir
      End If
      CommonDialog2.InitDir = XtractDir
   End If

   If GetAllEssentials Then
      ExtractAllEssentials XtractDir
   End If
   
      
End Sub
'recursive call to find extension node
Private Function ExtensionNode(E As IXMLDOMElement) As IXMLDOMElement
   Dim x As Integer
   Dim y As Integer
   Dim NodeName As String
   Dim SubE As IXMLDOMElement
   Dim RSubE As IXMLDOMElement
   
   On Error Resume Next
   
   For x = 0 To E.childNodes.length - 1
      If E.childNodes(x).nodeType = NODE_ELEMENT Then
         Set SubE = E.childNodes(x)
         NodeName = SubE.NodeName
         If NodeName = "xsd:extension" Then
            Set ExtensionNode = SubE
            Exit Function
         End If
         If SubE.childNodes.length > 0 Then
            For y = 0 To SubE.childNodes.length - 1
               If SubE.childNodes(y).nodeType = NODE_ELEMENT Then
                  Set RSubE = ExtensionNode(SubE.childNodes.Item(y))
                  Set ExtensionNode = RSubE
                  If RSubE.NodeName <> "" Then
                     If Err.Number = 0 Then
                        Exit Function
                     End If
                  End If
               End If
            Next
         End If
      End If
   Next
   
   
            
End Function
Private Function RemoveExtraNodes()
   Dim x As Integer
   Dim NodeName As String
   Dim E As IXMLDOMElement
   
   With FlatXSDDoc.documentElement.childNodes
      For x = .length - 1 To 1 Step -1
         If .Item(x).nodeType = NODE_ELEMENT Then
         Set E = .Item(x)
         NodeName = E.NodeName
         Select Case NodeName
         Case "xsd:annotation"
         Case "xsd:element"
         Case "xsd:include"
         Case Else
            FlatXSDDoc.documentElement.removeChild E
         End Select
         End If
      Next
   End With
End Function
Private Sub ExpandGroup(E As IXMLDOMElement, EltGroup As String)
   'find group definition
   'remove ref to group
   'insert group sub elements
   'look for definition of type within the document
   Dim x As Integer
   Dim SubE As IXMLDOMElement
   Dim GroupName As String
   Dim Found As Boolean
   
   With XSDDoc.documentElement.childNodes
      For x = 0 To .length - 1
'         Debug.Print .Item(x).NodeName
         If .Item(x).nodeType = NODE_ELEMENT Then
            Set SubE = .Item(x)
            If SubE.NodeName = "xsd:group" Then
               GroupName = getAttribVal(SubE, "name")
               If GroupName = EltGroup Then
                  Found = True
                  Exit For
               End If
            End If
         End If
      Next
   End With
   
   If Found Then
      'remove ref
      For x = 0 To E.Attributes.length - 1
         If E.Attributes(x).NodeName = "ref" Then
            E.Attributes.removeNamedItem "ref"
            Exit For
         End If
      Next
      'insert group elements
      For x = 0 To SubE.childNodes.length - 1
         E.appendChild SubE.childNodes(x).cloneNode(True)
      Next
   Else
      MsgBox "Group " & EltGroup & " not found", vbInformation
   End If
   
End Sub
Private Sub ExpandSubGroups(E As IXMLDOMElement)
   Dim x As Integer
   Dim y As Integer
   Dim SubE As IXMLDOMElement
   
   Dim GroupName As String
   
   Set SubE = SubGroup(E)
   
   For x = 0 To SubE.Attributes.length - 1
      If SubE.Attributes(x).NodeName = "ref" Then
         GroupName = SubE.Attributes(x).Text
         Exit For
      End If
   Next
   
'   GroupName = SubE.Attributes.getNamedItem("ref")
   
   If GroupName = "" Then Exit Sub
   ExpandGroup SubE, GroupName
   
End Sub
Private Function SubGroup(E As IXMLDOMElement) As IXMLDOMElement
   Dim x As Integer
   Dim SubE As IXMLDOMElement
   Dim NodeName As String
   Dim GroupE As IXMLDOMElement
   
   On Error Resume Next
   
   For x = 0 To E.childNodes.length - 1
      If E.childNodes(x).nodeType = NODE_ELEMENT Then
         Set SubE = E.childNodes(x)
         If SubE.NodeName = "xsd:group" Then
            Set SubGroup = SubE
            Exit Function
         End If
         If E.childNodes(x).childNodes.length > 0 Then
            Set GroupE = SubGroup(E.childNodes(x))
            Err.Clear
            NodeName = GroupE.NodeName
            If Err.Number = 0 Then
               Set SubGroup = GroupE
               Exit Function
            End If
         End If
      End If
   Next
   
End Function
Private Sub ExtractEssentials()
   
   Dim tNode As IXMLDOMNode
   Dim PI As IXMLDOMProcessingInstruction
   Dim C As IXMLDOMComment
   Dim x As Integer
   Dim y As Integer
   Dim E As IXMLDOMElement
   Dim SubE As IXMLDOMElement
   Dim SSubE As IXMLDOMElement
   Dim XPath As String
   
   Set EssentialEltDoc = New MSXML2.DOMDocument
   Set PI = EssentialEltDoc.createProcessingInstruction("xml", "version='1.0'")
   EssentialEltDoc.appendChild PI
   
   Set tNode = EssentialEltDoc.createElement("EssentialElts")
   Set mEltDescripts = New EltDiscriptors
   'add subnodes
   With FlatXSDDoc.documentElement.childNodes
      For x = 0 To .length - 1
         If .Item(x).nodeType = NODE_ELEMENT Then
            Set E = .Item(x)
            If E.NodeName = "xsd:element" Then
               XPath = getAttribVal(E, "name")
               Set C = EssentialEltDoc.createComment("Document root = " & XPath)
               tNode.appendChild C
               GetSubEltEssentials E, ""
               For y = 1 To mEltDescripts.Count
                  Set SubE = EssentialEltDoc.createElement("ElementDescription")
                  Set SSubE = EssentialEltDoc.createElement("EltName")
                  SSubE.Text = mEltDescripts(y).EltName
                  SubE.appendChild SSubE
                  Set SSubE = Nothing
                  Set SSubE = EssentialEltDoc.createElement("Description")
                  SSubE.Text = mEltDescripts(y).Description
                  SubE.appendChild SSubE
                  Set SSubE = Nothing
                  Set SSubE = EssentialEltDoc.createElement("EltType")
                  SSubE.Text = mEltDescripts(y).EltType
                  SubE.appendChild SSubE
                  Set SSubE = Nothing
                  Set SSubE = EssentialEltDoc.createElement("LineNumber")
                  SSubE.Text = mEltDescripts(y).LineNumber
                  SubE.appendChild SSubE
                  Set SSubE = Nothing
                  Set SSubE = EssentialEltDoc.createElement("XPath")
                  SSubE.Text = mEltDescripts(y).XPath
                  SubE.appendChild SSubE
                  Set SSubE = Nothing
                  tNode.appendChild SubE
                  Set SubE = Nothing
               Next
            End If
         End If
      Next
   End With
   
   EssentialEltDoc.appendChild tNode
   
End Sub

Private Sub GetSubEltEssentials(E As IXMLDOMElement, _
ByVal XPath As String)
   Dim x As Integer
   Dim y As Integer
   Dim SubE As IXMLDOMElement
   Dim mDesc As EltDiscription
   'element parts to save
   Dim EltName As String
   Dim EltType As String
   Dim LineNum As String
   Dim Desc As String
   
   If E.nodeType = NODE_ELEMENT Then
      If E.NodeName = "xsd:element" Then
         EltName = getAttribVal(E, "name")
         If EltName <> "" Then
            If XPath = "" Then
               XPath = EltName
            Else
               XPath = XPath & "/" & EltName
            End If
         End If
         EltType = getAttribVal(E, "type")
         If EltType = "" Then
            EltType = XsdExtensionBase(E)
         End If
         LineNum = GetLineNum(E)
         Desc = GetDescription(E)
         Set mDesc = New EltDiscription
         mDesc.EltName = EltName
         mDesc.XPath = XPath
         mDesc.Description = Desc
         mDesc.EltType = EltType
         mDesc.LineNumber = LineNum
         mEltDescripts.Add mDesc
         Set mDesc = Nothing
      End If
   End If
   
   
'   XPath = XPath & E.NodeName
   For x = 0 To E.childNodes.length - 1
      If E.childNodes(x).nodeType = NODE_ELEMENT Then
         Set SubE = E.childNodes(x)
         If SubE.childNodes.length > 0 Or SubE.NodeName = "xsd:element" Then
            GetSubEltEssentials SubE, XPath
         End If
      End If
   Next
   
End Sub
Private Function GetLineNum(E As IXMLDOMElement) As String
   Dim x As Integer
   Dim y As Integer
   Dim z As Integer
   Dim SubE As IXMLDOMElement
   Dim SSubE As IXMLDOMElement
   
   With E.childNodes
   For x = 0 To .length - 1
      If .Item(x).nodeType = NODE_ELEMENT Then
         Set SubE = .Item(x)
         If SubE.NodeName = "xsd:annotation" Then
            For y = 0 To SubE.childNodes.length - 1
               If SubE.childNodes(y).NodeName = "xsd:documentation" Then
                  For z = 0 To SubE.childNodes(y).childNodes.length - 1
                     If SubE.childNodes(y).childNodes(z).nodeType = NODE_ELEMENT Then
                        Set SSubE = SubE.childNodes(y).childNodes(z)
                        If SSubE.NodeName = "LineNumber" Then
                           GetLineNum = SSubE.Text
                           Exit Function
                        End If
                     End If
                  Next
               End If
            Next
         End If
      End If
   Next
   End With
   
End Function
Private Function GetDescription(E As IXMLDOMElement) As String
   Dim x As Integer
   Dim y As Integer
   Dim z As Integer
   Dim SubE As IXMLDOMElement
   Dim SSubE As IXMLDOMElement
   
   With E.childNodes
   For x = 0 To .length - 1
      If .Item(x).nodeType = NODE_ELEMENT Then
         Set SubE = .Item(x)
         If SubE.NodeName = "xsd:annotation" Then
            For y = 0 To SubE.childNodes.length - 1
               If SubE.childNodes(y).NodeName = "xsd:documentation" Then
                  For z = 0 To SubE.childNodes(y).childNodes.length - 1
                     If SubE.childNodes(y).childNodes(z).nodeType = NODE_ELEMENT Then
                        Set SSubE = SubE.childNodes(y).childNodes(z)
                        If SSubE.NodeName = "Description" Then
                           GetDescription = SSubE.Text
                           Exit Function
                        End If
                     End If
                  Next
               End If
            Next
         End If
      End If
   Next
   End With
   
End Function

Private Sub ExtractAllEssentials(XtractDir As String)
   Dim XSDFile As String
   Dim XMLFile As String
   Dim ButtonText As String
   
   On Error GoTo ErrHandler
   Screen.MousePointer = vbHourglass
   
   If Right(XSDDir, 1) <> "\" Then
      XSDDir = XSDDir & "\"
   End If
   
   XtractDir = Trim(XtractDir)
   ButtonText = Me.cmdGetEssentials.Caption
   Me.cmdGetEssentials.Caption = "Cancel"
   
   XSDFile = Dir(XSDDir)
   If XSDFile = "" Or XSDDir = "" Then
      MsgBox "XSDDir (" & XSDDir & ") not found", vbInformation
      Exit Sub
   End If
   
   Do While XSDFile <> ""
      DoEvents
      If CancelJob Then
         Me.cmdGetEssentials.Caption = ButtonText
         Exit Sub
      End If
      If LCase(XSDFile) <> "efiletypes.xsd" And _
        Right(LCase(XSDFile), 3) = "xsd" And _
        Left(LCase(XSDFile), 10) <> "returndata" And _
        InStr(1, LCase(XSDFile), "returnheader") = 0 _
        Then
         Me.txtInput.Text = XSDDir & XSDFile
         On Error Resume Next
         
         Set XSDDoc = New MSXML2.DOMDocument
         XSDDoc.resolveExternals = True
         XSDDoc.Load Me.txtInput.Text
         If XSDDoc.parseError.errorCode <> 0 Then
            MsgBox XSDDoc.parseError.reason, vbInformation
         End If
         On Error GoTo ErrHandler
         Me.txtXML.Text = XtractDir & NoExt(XSDFile) & ".xml"
         '1) clone the input xsd
         CloneInput
         '2) remove all but root, annotation and includes
         RemoveExtraNodes
         '3) expand nodes
         ExpandNodes
         '4) extract essentials using cloned xsd
         ExtractEssentials
         EssentialEltDoc.save Me.txtXML.Text
      End If
Cont:
      XSDFile = Dir()
      Me.StatusBar1.SimpleText = XSDFile
'      Debug.Print "XSDFile = " & XSDFile
   Loop
   
   Me.cmdGetEssentials.Caption = ButtonText
   Screen.MousePointer = vbNormal
   Exit Sub
   
ErrHandler:
   Debug.Print Err.Description
   GoTo Cont
   Resume Next
   Resume
End Sub
Private Function NoExt(FileName As String) As String
   Dim x As Integer
   For x = Len(FileName) To 1 Step -1
      If Mid(FileName, x, 1) = "." Then
         Exit For
      End If
   Next
   If x > 2 Then
      NoExt = Left(FileName, x - 1)
   Else
      NoExt = FileName
   End If
   
End Function
Private Function Path(FileName As String) As String
   Dim x As Integer
   For x = Len(FileName) To 1 Step -1
      If Mid(FileName, x, 1) = "\" Then
         Exit For
      End If
   Next
   
   If x > 0 Then
      Path = Left(FileName, x)
   End If
End Function
Private Function NoPath(FileName As String) As String
   Dim x As Integer
   For x = Len(FileName) To 1 Step -1
      If Mid(FileName, x, 1) = "\" Then
         Exit For
      End If
   Next
   
   If x > 0 Then
      NoPath = Mid(FileName, x + 1)
   End If

End Function

