Attribute VB_Name = "modHTMLHelp"
Option Explicit

Const HH_DISPLAY_TOPIC = &H0
Const HH_SET_WIN_TYPE = &H4
Const HH_GET_WIN_TYPE = &H5
Const HH_GET_WIN_HANDLE = &H6
Const HH_DISPLAY_TEXT_POPUP = &HE   ' Display string resource ID or
                                    ' text in a pop-up window.
Const HH_HELP_Context = &HF         ' Display mapped numeric value in
                                    ' dwData.
Const HH_TP_HELP_CONTEXTMENU = &H10 ' Text pop-up help, similar to
                                    ' WinHelp's HELP_CONTEXTMENU.
Const HH_TP_HELP_WM_HELP = &H11     ' text pop-up help, similar to
                                    ' WinHelp's HELP_WM_HELP.
Const HH_DISPLAY_SEARCH = &H3
Declare Function HtmlHelp Lib "hhctrl.ocx" Alias "HtmlHelpA" _
        (ByVal hwndCaller As Long, ByVal pszFile As String, _
        ByVal uCommand As Long, ByVal dwData As Long) As Long


' HTML Help file launched in response to a button click:
Public Sub HH_DISPLAY_Topics(sHelpFile As String)
'hWnd is a Long defined elsewhere to be the window handle
'that will be the parent to the help window.
   Dim hwndHelp As Long
   Dim hwnd As Long
   Dim hFile As String
   
   On Error GoTo ErrHandler
   
   hFile = App.path & "\" & sHelpFile
   If dir(hFile) = "" Then
      MsgBox "Help can't be displayed, missing " & hFile & _
      vbNewLine & _
      "Try searching for this file and opening it. " & _
      vbNewLine & _
      "The file should be in the same directory as your program", _
      vbInformation
      Exit Sub
   End If
   
   'The return value is the window handle of the created help window.
   hwndHelp = HtmlHelp(hwnd, App.path & "\" & sHelpFile, HH_DISPLAY_TOPIC, 0)
   
   Exit Sub
   
ErrHandler:

   MsgBox Err.Description
   Resume Next
   Resume
End Sub

' A specific topic identified by the variable ContextID is launched
' in response to this button click:
Public Sub HH_HELP_ContextID(sHelpFile As String, ContextID As Long)
   Dim hwndHelp As Long
   Dim hwnd As Long
   
   'The return value is the window handle of the created help window.
  hwndHelp = HtmlHelp(hwnd, App.path & "\" & sHelpFile, HH_HELP_Context, ContextID)
End Sub

Public Sub HH_DISPLAY_TOC(sHelpFile As String, HelpIx As Integer)
'hWnd is a Long defined elsewhere to be the window handle
'that will be the parent to the help window.
   Dim hwndHelp As Long
   Dim hwnd As Long
   
   On Error Resume Next

   'The return value is the window handle of the created help window.
   hwndHelp = HtmlHelp(hwnd, App.path & "\" & sHelpFile, HH_DISPLAY_SEARCH, 0)
   If Err Then
       MsgBox Err.Description
   End If

End Sub

