<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;"> 
	<!ENTITY mdash "&#8212;"> 
]>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:include href="PopulateTemplate.xsl"/>
	<xsl:include href="AddHeader.xsl"/>
	<xsl:include href="CommonPathRef.xsl"/>
	<xsl:include href="AddOnTable.xsl"/>
	<xsl:include href="IRS7211Style.xsl"/>
	<xsl:output method="html" indent="yes"/>
	<xsl:strip-space elements="*"/>
	<xsl:param name="FormData" select="$RtnDoc/IRS7211"/>
	<xsl:template match="/">
		<xsl:text disable-output-escaping="yes">&lt;!DOCTYPE html&gt;</xsl:text>
		<html lang="EN-US">
			<head>
				<meta http-equiv="X-UA-Compatible" content="IE=edge"/>
				<title>
					<xsl:call-template name="FormTitle">
						<xsl:with-param name="RootElement" select="local-name($FormData)"/>
					</xsl:call-template>
				</title>
				<!-- No Browser Caching -->
				<meta http-equiv="Pragma" content="no-cache"/>
				<meta http-equiv="Cache-Control" content="no-cache"/>
				<meta http-equiv="Expires" content="0"/>
				<!-- No Proxy Caching -->
				<meta http-equiv="Cache-Control" content="private"/>
				<!-- Define Character Set -->
				<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"/>
				<meta name="Description" content="IRS Form 7211"/>
				<script language="JavaScript" src="{$ScriptPath}/FormDisplay.js" type="text/javascript"/>
				<xsl:call-template name="InitJS"/>
				<style type="text/css">
					<xsl:if test="not($Print) or $Print=''">
						<xsl:call-template name="IRS7211Style"/>
						<xsl:call-template name="AddOnStyle"/>
					</xsl:if>
				</style>
				<xsl:call-template name="GlobalStylesForm"/>
			</head>
			<body class="styBodyClass">
				<form id="Form7211">
					<xsl:call-template name="DocumentHeader"/>
					<!-- Page 1 -->
					<!-- Header -->
					<div class="styStdDiv">
						<div class="styFNBox" style="width:30mm;height:22.5mm;">
							Form <span class="styFN" style="font-size:18pt;">7211</span>
							<br/>(December 2024)
							<xsl:call-template name="SetFormLinkInline">
								<xsl:with-param name="TargetNode" select="$FormData"/>
							</xsl:call-template>
							<br/>
							<br/>
							<span class="styAgency">
								Department of the Treasury <br/>
								Internal Revenue Service
							</span>
						</div>
						<div class="styFTBox" style="width:127mm;height:22.5mm;">
							<span class="styFMT" style="font-size:14pt;padding-top:1mm;padding-bottom:1mm;">Clean Electricity Production Credit</span>
							<br/>
							<br/>
							<span style="font-weight:bold;">
								Attach to your tax return.
							</span>
							<br/>
							<br/>
							<span style="font-weight:bold;">
								Go to
								<span style="font-style:italic">www.irs.gov/Form7211</span>
								for instructions and the latest information.
							</span>
						</div>
						<div class="styTYBox" style="width:30mm;height:22.5mm;">
							<div class="styOMB" style="height:10mm;font-size:7pt;padding-top:3mm;">OMB No. 1545-0123</div>
							<div style="margin-left:2mm;text-align:left;font-size:7pt;padding-top:2mm;">
								Attachment<br/>Sequence No. 
								<span class="styBoldText" style="font-size:9pt;">211</span>
							</div>
						</div>
					</div>
					<!-- Filer information section -->
					<div class="sty7211LineDiv" style="border-top:2px solid black;">
						<div class="styNameBox" style="width:135mm;">
							 Name(s) shown on return <br/>
							<xsl:call-template name="PopulateReturnHeaderFiler">
								<xsl:with-param name="TargetNode">BusinessNameLine1Txt</xsl:with-param>
							</xsl:call-template>
							<br/>
							<xsl:call-template name="PopulateReturnHeaderFiler">
								<xsl:with-param name="TargetNode">BusinessNameLine2Txt</xsl:with-param>
							</xsl:call-template>
						</div>
						<div class="styEINBox" style="width:52mm;padding-left:0.5mm;font-weight:normal;">
							<span style="width:0.5mm;height:1mm;"/>
							<strong> Identifying number</strong>
							<br/>
							<xsl:call-template name="PopulateReturnHeaderFilerTIN"/>
						</div>
					</div>
					<!-- Part 1 -->
					<div class="styStdDiv" style="border-bottom:1px solid black;border-top:1px solid black;">
						<div class="styPartName">Part I</div>
						<div class="styPartDesc">
							Information on Qualified Facility
						</div>
					</div>
					<!-- Line 1 -->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">1</div>
						<div class="styLNDesc" style="width:140mm;height:auto">If making an elective payment election or transfer election, enter the IRS-issued registration number <span> of the facility:</span>
							<span>
								<div class="styLNDesc" style="width:45mm; border-bottom:1px solid black;margin-bottom:1px;">
									<xsl:call-template name="PopulateText">
										<xsl:with-param name="TargetNode" select="$FormData/FacilityIRSIssdRegistrationNum"/>
									</xsl:call-template>
								</div>
							</span>
						</div>
					</div>
					<!-- Line 2 -->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">2a</div>
					<div class="styLNDesc" style="width:65mm;height:auto;">If different than filer, enter the (i) owner’s name</div> 
						 <xsl:choose>
							<xsl:when test="$FormData/FacilityOwnerPersonNm">	
								<span style="border-bottom:1px solid black;width:110mm;padding-right:4mm;">							
									<xsl:call-template name="PopulateText">
										<xsl:with-param name="TargetNode" select="$FormData/FacilityOwnerPersonNm"/>
									</xsl:call-template> 
								</span>
								<br/><br/>
								<span style="padding-right:2mm;padding-left:8mm;">and (ii) Owner's TIN:</span>
								<span style="border-bottom:1px solid black;width:32mm;">									
									
							<xsl:call-template name="PopulateSSN">
<xsl:with-param name="TargetNode" select="$FormData/FacilityOwnerSSN"/>
</xsl:call-template>						
									
								</span>	
							</xsl:when>	 
							<xsl:otherwise>	  
							<span style="border-bottom:1px solid black;width:110mm;padding-right:4mm;">	
									<xsl:call-template name="PopulateReturnHeaderFiler">
										<xsl:with-param name="TargetNode">BusinessNameLine1Txt</xsl:with-param>
									</xsl:call-template>
									<br/>
									<xsl:call-template name="PopulateReturnHeaderFiler">
										<xsl:with-param name="TargetNode">BusinessNameLine2Txt</xsl:with-param>
									</xsl:call-template>
								</span>	
								<br/><br/>
								<span style="padding-right:2mm;padding-left:8mm;">and (ii) Owner's TIN:</span>
								<span style="border-bottom:1px solid black;width:32mm;">					
								<xsl:call-template name="PopulateReturnHeaderFiler">
<xsl:with-param name="TargetNode">EIN</xsl:with-param>
<xsl:with-param name="EINChanged">true</xsl:with-param>
</xsl:call-template>
								
								</span>
							</xsl:otherwise>
						</xsl:choose>.
					
					</div>
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD" style="padding-left:4.2mm;"> b</div>
						<div class="styLNDesc" style="width:51mm;">Address and description of the facility:</div>
						<div class="styLNDesc" style="width:128mm;min-height:3.5mm;height:auto;border-bottom:1px dotted;margin-bottom:1px;">
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/FacilityUSAddress"/>
							</xsl:call-template>
						</div>
						<div class="styStdDiv">
							<div class="styLNLeftNumBox">&nbsp;</div>
							<div class="styLNDesc" style="width:178.9mm;min-height:3mm;height:auto;border-bottom:1px solid black;">
								<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="$FormData/FacilityDesc"/>
								</xsl:call-template>
							</div>
						</div>
					</div>
					<div class="styStdDiv" style="margin-top:1mm;">
						<div class="styLNLeftNumBoxSD" style="padding-left:4.2mm;heiht:2mm">c  </div>
						<div class="styLNDesc" style="width:50mm;">Coordinates. &nbsp;<br/>
						</div>
					</div>
					<div class="styStdDiv" style="margin-top:1mm;">
						<div class="styLNLeftNumBoxSD" style="padding-left:4.2mm;"/>
						<div class="styLNDesc" style="width:20mm;">
							<span style="font-weight:bold;">(i)  </span> Latitude: </div>
						<div class="styLNDesc" style="width:50mm;height:auto;">
							<div style="width:100%;border:1px solid black;text-align:center;">
								<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="$FormData/FacilityLatitudeNum"/>
								</xsl:call-template>
							</div>
							<span style="font-family:Arial Narrow;">Enter a "+" (plus) or "-" (minus) sign in the first box.</span>
						</div>
						<div class="styLNDesc" style="width:30mm;padding-left:8mm;">
							<span style="font-weight:bold;"> (ii) </span>   Longitude: </div>
						<div class="styLNDesc" style="width:50mm;height:auto;">
							<div style="width:100%;border:1px solid black;text-align:center;">
								<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="$FormData/FacilityLongitudeNum"/>
								</xsl:call-template>
							</div>
							<span style="font-family:Arial Narrow;">Enter a "+" (plus) or "-" (minus) sign in the first box.</span>
						</div>
					</div>
					<!-- Line 3 -->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">3</div>
						<div class="styLNDesc" style="width:53mm;height:4mm;">Date construction began (MM/DD/YYYY): </div>
						<div class="styLNDesc" style="width:60mm;height:4mm;border-bottom:1px solid black;margin-bottom:1px;text-align:center;">
							<xsl:call-template name="PopulateMonthDayYear">
								<xsl:with-param name="TargetNode" select="$FormData/FacilityConstructionStartDt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Line 4 -->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">4</div>
						<div class="styLNDesc" style="width:53mm;height:4mm;">Date placed in service (MM/DD/YYYY): </div>
						<div class="styLNDesc" style="width:60mm;height:4mm;border-bottom:1px solid black;margin-bottom:1px;text-align:center;">
							<xsl:call-template name="PopulateMonthDayYear">
								<xsl:with-param name="TargetNode" select="$FormData/FacilityPlacedInServiceDt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Line 5-->
					<div class="styIRS7211LineItem" style="height:14mm;">
						<div class="styLNLeftNumBoxSD">5</div>
						<div class="styIRS7211LNDesc" style="width:170mm;height:2mm;">
								If you petitioned for a provisional emissions rate (PER), check the applicable box below:<br/>
						</div>
						<br/>
						<div class="styIRS7211LNDesc" style="width:160mm;">
							<span>
								<xsl:call-template name="PopulateSpan">
									<xsl:with-param name="TargetNode" select="$FormData/EmissionsValueRcvdDOEInd"/>
								</xsl:call-template>
							</span>
							<span>
								<span style="font-weight:bold;width:4mm;"> (i)</span>
								<input type="checkbox" class="styCkbox" alt="Emissions Value Rcvd DOE Ind ">
									<xsl:call-template name="PopulateCheckbox">
										<xsl:with-param name="TargetNode" select="$FormData/EmissionsValueRcvdDOEInd"/>
										<xsl:with-param name="BackupName">IRS7211EmissionsValueRcvdDOEInd</xsl:with-param>
									</xsl:call-template>
								</input>
								<span style="width:2mm;"/>
								<label>
									<xsl:call-template name="PopulateLabel">
										<xsl:with-param name="TargetNode" select="$FormData/EmissionsValueRcvdDOEInd"/>
										<xsl:with-param name="BackupName">IRS7211EmissionsValueRcvdDOEIndInd</xsl:with-param>
									</xsl:call-template>
								</label>An emissions value was received from the Department of Energy (DOE).<br/>
								<!-- ++++++++++++++ No Checkbox +++++++++++++ -->
								<span style="font-weight:bold;width:4mm;">(ii)</span>
								<input type="checkbox" class="styCkbox" alt="LCA Model ">
									<xsl:call-template name="PopulateCheckbox">
										<xsl:with-param name="TargetNode" select="$FormData/LCAModelInd"/>
										<xsl:with-param name="BackupName">IRS7211LCAModelInd</xsl:with-param>
									</xsl:call-template>
								</input>
								<span style="width:2mm;"/>
								<label>
									<xsl:call-template name="PopulateLabel">
										<xsl:with-param name="TargetNode" select="$FormData/LCAModelInd"/>
										<xsl:with-param name="BackupName">IRS7211LCAModelInd</xsl:with-param>
									</xsl:call-template>
								</label>
								<span style="width:120mm;">A designated Lifecycle Analysis (LCA) model was used to recommend an emissions value.
</span>
							</span>
						</div>
					</div>
					<!--Line  6 -->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">6</div>
						<div class="styLNDesc" style="width:58mm;padding-bottom:6mm;">
							Enter the DOE control number, if applicable:						
						</div>
						<div class="styLNDesc" style="width:60mm;min-height:3mm;height:auto;border-bottom:1px solid black;margin-bottom:1px;">
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/DOEControlNum"/>
							</xsl:call-template>
						</div>
					</div>
					<!--Line  7 -->
					<div class="styIRS7211LineItem" style="height:25mm;">
						<div class="styLNLeftNumBoxSD">7</div>
						<div class="styIRS7211LNDesc" style="width:150mm;height:3mm;">
								Does the facility qualify to claim the credit at the alternative amount? See instructions.	
							</div>
						<br/>
						<!--a-->
						<div style="width:187mm;">
							<div class="styLNLeftLtrBox" style="padding-left:4mm;padding-top:1.5mm;">a</div>
							<div class="styLNDesc" style="width:178mm;">
								<input type="checkbox" class="styCkbox" alt="Project NetOutput Under 1MWInd">
									<xsl:call-template name="PopulateCheckbox">
										<xsl:with-param name="TargetNode" select="$FormData/ProjectNetOutputUnder1MWInd"/>
										<xsl:with-param name="BackupName">Project NetOutput Under1MW</xsl:with-param>
									</xsl:call-template>
								</input>
								<label>
									<xsl:call-template name="PopulateLabel">
										<xsl:with-param name="TargetNode" select="$FormData/ProjectNetOutputUnder1MWInd"/>
										<xsl:with-param name="BackupName">Project NetOutput Under1MW</xsl:with-param>
									</xsl:call-template>Yes, the facility’s maximum net output is less than 1 megawatt (as measured in alternating current).  
							</label>
							</div>
						</div>
						<!--b-->
						<div style="width:187mm;">
							<div class="styLNLeftLtrBox" style="padding-left:4mm;padding-top:1.5mm;">b</div>
							<div class="styLNDesc" style="width:158mm;">
								<input type="checkbox" class="styCkbox" alt="Fclty Constr Began Bfr SpcfdDtInd">
									<xsl:call-template name="PopulateCheckbox">
										<xsl:with-param name="TargetNode" select="$FormData/FcltyConstrBeganBfrSpcfdDtInd"/>
										<xsl:with-param name="BackupName">FcltyConstr Began BfrSpcfdDt</xsl:with-param>
									</xsl:call-template>
								</input>
								<label>
									<xsl:call-template name="PopulateLabel">
										<xsl:with-param name="TargetNode" select="$FormData/FcltyConstrBeganBfrSpcfdDtInd"/>
										<xsl:with-param name="BackupName">FcltyConstr Began BfrSpcfdDt</xsl:with-param>
									</xsl:call-template>Yes, the facility’s construction began before January 29, 2023.  
						  </label>
							</div>
						</div>
						<!--c-->
						<div style="width:187mm;">
							<div class="styLNLeftLtrBox" style="padding-left:4mm;height:2.5mm;">c</div>
							<div class="styLNDesc" style="width:158mm;">
								<input type="checkbox" class="styCkbox" alt="Fclty StsfyWg Aprntcshp RqrInd">
									<xsl:call-template name="PopulateCheckbox">
										<xsl:with-param name="TargetNode" select="$FormData/FcltyStsfyWgAprntcshpRqrInd"/>
										<xsl:with-param name="BackupName">Fclty Stsfy WgAprntcshpRqr</xsl:with-param>
									</xsl:call-template>
								</input>
								<label>
									<xsl:call-template name="PopulateLabel">
										<xsl:with-param name="TargetNode" select="$FormData/FcltyStsfyWgAprntcshpRqrInd"/>
										<xsl:with-param name="BackupName">Fclty Stsfy WgAprntcshpRqr</xsl:with-param>
									</xsl:call-template>Yes, the facility meets the prevailing wage requirements of section 45(b)(7)(A) and the apprenticeship requirements of<br/>
									<span style="padding-right:5mm;"/>section 45(b)(8).<br/>
								</label>
							</div>
						</div>
						<br/>
						<br/>
						<!--d-->
						<div style="width:187mm;">
							<div class="styLNLeftLtrBox" style="padding-left:4mm;padding-top:1.5mm;">d</div>
							<div class="styLNDesc" style="width:178mm;">
								<input type="checkbox" class="styCkbox" alt="Fclty Qlfy ClmCr AltAmtNoInd">
									<xsl:call-template name="PopulateCheckbox">
										<xsl:with-param name="TargetNode" select="$FormData/FcltyQlfyClmCrAltAmtNoInd"/>
										<xsl:with-param name="BackupName">Fclty QlfyClmCr AltAmtNo</xsl:with-param>
									</xsl:call-template>
								</input>
								<label>
									<xsl:call-template name="PopulateLabel">
										<xsl:with-param name="TargetNode" select="$FormData/FcltyQlfyClmCrAltAmtNoInd"/>
										<xsl:with-param name="BackupName">Fclty QlfyClm CrAltAmtNo</xsl:with-param>
									</xsl:call-template>No.  
							</label>
							</div>
						</div>
					</div>
					<!-- (8) -->
					<div class="styIRS7211LineItem" style="height:14mm;">
						<div class="styLNLeftNumBoxSD">8</div>
						<div class="styIRS7211LNDesc" style="width:170mm;">
						Does the facility qualify for an energy community bonus credit?
							</div>
						<br/>
						<div class="styIRS7211LNDesc" style="width:170mm;">
							<!-- ++++++++++++++ Yes Checkbox +++++++++++++ -->
							<span>
								<xsl:call-template name="PopulateSpan">
									<xsl:with-param name="TargetNode" select="$FormData/QlfyEgyComBonusCrInd"/>
								</xsl:call-template>
							</span>
							<span>
								<input type="checkbox" class="styCkbox" alt="Qlfy  Egy Com Bonus Cr Indicator Yes">
									<xsl:call-template name="PopulateYesCheckbox">
										<xsl:with-param name="TargetNode" select="$FormData/QlfyEgyComBonusCrInd"/>
										<xsl:with-param name="BackupName">IRS7211YesQlfyEgyComBonusCrInd</xsl:with-param>
									</xsl:call-template>
								</input>
								<span style="width:2mm;"/>
								<label>
									<xsl:call-template name="PopulateLabelYes">
										<xsl:with-param name="TargetNode" select="$FormData/QlfyEgyComBonusCrInd"/>
										<xsl:with-param name="BackupName">IRS7211YesQlfyEgyComBonusCrInd</xsl:with-param>
									</xsl:call-template>
								</label>
										Yes, the facility qualifies for the energy community bonus credit under section 45Y(g)(7).
<br/>
								<!-- ++++++++++++++ No Checkbox +++++++++++++ -->
								<input type="checkbox" class="styCkbox" alt="Qlfy Egy Com Bonus Cr">
									<xsl:call-template name="PopulateNoCheckbox">
										<xsl:with-param name="TargetNode" select="$FormData/QlfyEgyComBonusCrInd"/>
										<xsl:with-param name="BackupName">IRS7211QlfyEgyComBonusCrInd</xsl:with-param>
									</xsl:call-template>
								</input>
								<span style="width:2mm;"/>
								<label>
									<xsl:call-template name="PopulateLabelNo">
										<xsl:with-param name="TargetNode" select="$FormData/QlfyEgyComBonusCrInd"/>
										<xsl:with-param name="BackupName">IRS7211QlfyEgyComBonusCrInd</xsl:with-param>
									</xsl:call-template>
								</label>
										No.
								</span>
						</div>
					</div>
					<!-- (9) ////////////////////////////////////////////////////-->
					<div class="styIRS7211LineItem" style="height:14mm;">
						<div class="styLNLeftNumBoxSD">9</div>
						<div class="styIRS7211LNDesc" style="width:170mm;">
								Does the facility qualify for the domestic content bonus credit?
							</div>
						<br/>
						<div class="styIRS7211LNDesc" style="width:170mm;">
							<!-- ++++++++++++++ Yes Checkbox +++++++++++++ -->
							<span>
								<xsl:call-template name="PopulateSpan">
									<xsl:with-param name="TargetNode" select="$FormData/PropertyQualifyDomBonusCrInd"/>
								</xsl:call-template>
							</span>
							<span>
								<input type="checkbox" class="styCkbox" alt="Property Qualify DomBonusCr Indicator Yes">
									<xsl:call-template name="PopulateYesCheckbox">
										<xsl:with-param name="TargetNode" select="$FormData/PropertyQualifyDomBonusCrInd"/>
										<xsl:with-param name="BackupName">IRS7211YesPropertyQualifyDomBonusCrInd</xsl:with-param>
									</xsl:call-template>
								</input>
								<span style="width:2mm;"/>
								<label>
									<xsl:call-template name="PopulateLabelYes">
										<xsl:with-param name="TargetNode" select="$FormData/PropertyQualifyDomBonusCrInd"/>
										<xsl:with-param name="BackupName">IRS7211YesPropertyQualifyDomBonusCrInd</xsl:with-param>
									</xsl:call-template>
								</label>
										Yes, the facility qualifies for the domestic content bonus credit under section 45Y(g)(11).
<br/>
								<!-- ++++++++++++++ No Checkbox +++++++++++++ -->
								<input type="checkbox" class="styCkbox" alt="Property Qualify Dom Bonus Cr Indicator No">
									<xsl:call-template name="PopulateNoCheckbox">
										<xsl:with-param name="TargetNode" select="$FormData/PropertyQualifyDomBonusCrInd"/>
										<xsl:with-param name="BackupName">IRS7211/PropertyQualifyDomBonusCrIn</xsl:with-param>
									</xsl:call-template>
								</input>
								<span style="width:2mm;"/>
								<label>
									<xsl:call-template name="PopulateLabelNo">
										<xsl:with-param name="TargetNode" select="$FormData/PropertyQualifyDomBonusCrInd"/>
										<xsl:with-param name="BackupName">IRS7211PropertyQualifyDomBonusCrInd</xsl:with-param>
									</xsl:call-template>
								</label>
										No.
								</span>
						</div>
					</div>
					<!-- Part 2 -->
					<div class="styStdDiv" style="border-bottom:1px solid black;border-top:1px solid black;">
						<div class="styPartName">Part II</div>
						<div class="styPartDesc" style="">
							Clean Electricity Production
						</div>
					</div>
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">&nbsp;</div>
						<div class="sty7211Desc" style="height:15mm;width:85mm;">
							<br/>
							The Rate you enter in (b) will depend on how you answered  part I,<br/>
							question 7, and the calendar year in which you sold, consumed or <br/>
							stored the kWh of qualified clean electricity. See instructions for<br/>
							information on calculating the rate.
						</div>
						<div class="sty7211QtyBox" style="text-align:center;padding:2mm;height:20mm;width:40mm;">
							<strong>(a)</strong>
							<br/>Kilowatt-hours of<br/> qualified <br/> clean electricity<br/>
						</div>
						<div class="styLNAmountBox" style="height:20mm;text-align:center;width:25mm">
							<strong><br/><br/>(b)</strong>
							<br/>Applicable Amount
						</div>
						<div class="styLNAmountBox" style="height:20mm;text-align:center;width:29mm">
							<strong><br/><br/>(c)</strong>
							<br/>Column (a) x Column (b)</div>
					</div>
					<!-- Line 1 -->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">1</div>
						<div class="sty7211Desc">
							<div class="styLNDesc" style="width:20mm;">
							Calendar Year:</div>
<div class="styLNDesc" style="width:6mm;border-bottom:2px solid;margin-bottom:1px;text-align:center;">											<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="$FormData/CleanElectricityProdGrp[1]/CalendarYr"/>
								</xsl:call-template>
							</div>
							<span class="sty7211DotLn">...........</span>
						</div>
						<div class="styLNRightNumBox" style="border-top:1px solid black;padding-top:1mm;">1</div>
			<div class="sty7211QtyBox" style="width:40mm;border-bottom:1px solid black;margin-bottom:1px;text-align:center;">
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/CleanElectricityProdGrp[1]/KilowattHrsQty"/>
							</xsl:call-template>
						</div>
						<div class="styLNAmountBox" style="width:25mm">
							<xsl:call-template name="PopulateAmount">
				<xsl:with-param name="TargetNode" select="$FormData/CleanElectricityProdGrp[1]/InflationAdjustedCreditRtAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNAmountBox" style="width:29mm;">
							<xsl:call-template name="PopulateAmount">
						<xsl:with-param name="TargetNode" select="$FormData/CleanElectricityProdGrp[1]/CalculatedCreditAmt"/>
							</xsl:call-template>
						</div>
					</div>
					
					<!-- Line 2 -->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD">2</div>
						<div class="sty7211Desc">
							<div class="styLNDesc" style="width:20mm;">
							Calendar Year:</div>
<div class="styLNDesc" style="width:6mm;border-bottom:2px solid;margin-bottom:1px;text-align:center;">											<xsl:call-template name="PopulateText">
									<xsl:with-param name="TargetNode" select="$FormData/CleanElectricityProdGrp[2]/CalendarYr"/>
								</xsl:call-template>
							</div>
							<span class="sty7211DotLn">...........</span>
						</div>
						<div class="styLNRightNumBox" style="padding-top:1mm;">2</div>
			<div class="sty7211QtyBox" style="width:40mm;border-bottom:1px solid black;margin-bottom:1px;text-align:center;">
							<xsl:call-template name="PopulateText">
								<xsl:with-param name="TargetNode" select="$FormData/CleanElectricityProdGrp[2]/KilowattHrsQty"/>
							</xsl:call-template>
						</div>
						<div class="styLNAmountBox" style="width:25mm">
							<xsl:call-template name="PopulateAmount">
				<xsl:with-param name="TargetNode" select="$FormData/CleanElectricityProdGrp[2]/InflationAdjustedCreditRtAmt"/>
							</xsl:call-template>
						</div>
						<div class="styLNAmountBox" style="width:29mm;">
							<xsl:call-template name="PopulateAmount">
						<xsl:with-param name="TargetNode" select="$FormData/CleanElectricityProdGrp[2]/CalculatedCreditAmt"/>
							</xsl:call-template>
						</div>
					</div>					
					
					
					<!-- Line 3-->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD"> 3</div>
						<div class="styLNDesc" style="height:auto;width:142mm;">
							Enter the total amount of lines 1(c) and 2(c). See instructions						
							<span class="sty7211DotLn">...............</span>
						</div>
						<div class="styLNRightNumBox" style="height:7mm;">
							<br/>3</div>
						<div class="styLNAmountBox" style="height:7mm;width:29mm;">
							<br/>
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TotalCreditAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Line 4-->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD"> 4</div>
						<div class="styLNDesc" style="height:7mm;width:142mm;">
							Reserved for future use 						
							<span class="sty7211DotLn">...........................</span>
						</div>
						<div class="styLNRightNumBox" style="height:7mm;">
							<br/>4</div>
						<div class="styLNAmountBox" style="height:7mm;width:29mm;background-color:lightgray;">
							<br/>
						</div>
					</div>
					<!-- Line 5a-->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD"> 5a</div>
						<div class="styLNDesc" style="height:8mm;width:142mm;">
							Energy community bonus credit. See instructions. If you qualify, multiply the amount on line 3 by<br/>
							10% (0.10). Otherwise, enter -0-						
							<span class="sty7211DotLn">.......................</span>
						</div>
						<div class="styLNRightNumBox" style="height:8mm;">
							<br/>5a</div>
						<div class="styLNAmountBox" style="height:8mm;width:29mm;">
							<br/>
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/EnergyCommunityBonusCreditAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Line 5b-->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD" style="padding-left:4.5mm">b</div>
						<div class="styLNDesc" style="height:auto;width:142mm;">
							Add lines 3 and 5a 						
							<span class="sty7211DotLn">............................</span>
						</div>
						<div class="styLNRightNumBox" style="height:7mm;">
							<br/>5b</div>
						<div class="styLNAmountBox" style="height:7mm;width:29mm;">
							<br/>
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/CreditBeforeReductionAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<div class="styStdDiv pageEnd" style="border-top:1px solid black;">
						<span style="font-weight:bold;font-family:Arial;"/>
						<span style="margin-left:20mm;"/>
						<span style="float:left;">
							<strong>For Paperwork Reduction Act Notice, see the separate instructions.</strong>
						</span>
						<span> Cat. No. 56405V</span>
						<span style="float:right;">Form <strong>7211</strong> (12-2024)</span>
					</div>
					<!-- Part 3 -->
					<div class="styStdDiv" style="border-bottom:1px solid black;">
				Form 7211 (12-2024)
				<div style="float:right;">Page <strong>2</strong>
						</div>
					</div>
					<div class="styPartName">Part II</div>
					<div class="styPartDesc" style="">
							Clean Electricity Production <span style="font-weight:normal;font-style:italic;">(continued)</span>
					</div>
					<div class="styStdDiv" style="border-bottom:.5px solid black;border-top:.5px solid black;"/>
					<div class="styStdDiv">
						<div class="styLNDesc" style="width:150mm;height:auto;"><br/>
						<b>Credit Reduction for Tax-Exempt bonds</b><br/>
							If you used proceeds of tax-exempt bonds to finance your facility, continue to line 6a; 
							otherwise, enter the <br/>amount from line 5b on line 7.
						</div>
						<div class="styLNRightNumBoxNBB" style="height:13mm;background-color:lightgrey;">&nbsp;</div>
						<div class="styLNAmountBoxNBB" style="height:13mm;width:29mm;">&nbsp;</div>
					</div>
					<!-- Line 6a -->
					<div class="styStdDiv">
						<div class="styLNLeftNumBox">6a</div>
						<div class="styLNDesc" style="height:auto;width:142mm;">
							<span class="styGenericDiv" style="font-weight:bold;width:30mm;">Divide. </span>
							<span class="styGenericDiv" style="width:135mm;height:auto;">
								<span style="width:60%;text-align:justify;">
									Sum, for the tax year and all prior tax years, of all proceeds of <br/>tax-exempt bonds 
									(within the meaning of section 103), used to finance the qualified facility as of the close of the tax year
								</span>
								<span style="width:142mm;">
								<span style="width:60%;height:3px;border-top:1px solid black;margin-bottom:3px;"/>
									<span class="sty7211DotLn">=..........</span>
								</span>
								<span style="width:60%;text-align:justify;">
								Aggregate amount of additions to the capital account for the
qualified facility, for the tax year and all prior tax years, as of the close of the tax year
								</span>
							</span>
						</div>
						<div class="styLNRightNumBoxNBB" style="height:11mm;background-color:lightgrey;">&nbsp;</div>
					 <div class="styLNAmountBoxNBB" style="height:11mm;width:29mm;">&nbsp;</div>  
						<div class="styLNRightNumBox">6a</div>
						<div class="styLNAmountBox" style="width:29mm;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/CalcTaxExemptBondsPct"/>
							</xsl:call-template>
						</div>
						<div class="styLNRightNumBoxNBB" style="height:10mm;background-color:lightgrey;">&nbsp;</div>
						<div class="styLNAmountBoxNBB" style="height:10mm;width:29mm;">&nbsp;</div>
					</div>
					<!-- Line 6b -->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD" style="padding-left:3mm;">b</div>
						<div class="styLNDesc" style="height:4.5mm;width:142mm;">
							Multiply line 5b by line 6a
							<span class="sty7211DotLn">.........................</span>
						</div>
						<div class="styLNRightNumBox" style="height:4.5mm;">6b</div>
						<div class="styLNAmountBox" style="height:4.5mm;width:29mm;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/CreditBeforeReductionFncAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Line 6c -->
					<div class="styStdDiv" style="hight:6mm;">
						<div class="styLNLeftNumBoxSD" style="height:6mm;padding-left:3mm;;padding-top:3mm;">c</div>
						<div class="styLNDesc" style="height:auto;width:142mm;padding-top:3mm;">
							Multiply line 5b by 15% (0.15)
							<span class="sty7211DotLn">........................</span>
						</div>
						<div class="styLNRightNumBox" style="height:7mm;">
							<br/>6c</div>
						<div class="styLNAmountBox" style="height:7mm;width:29mm;">
							<br/>
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/CreditBeforeReductionPctAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Line 6d -->
					<div class="styStdDiv">
						<div class="styLNLeftNumBoxSD" style="height:7mm;padding-left:3mm;;padding-top:3mm;">d</div>
						<div class="styLNDesc" style="height:auto;width:142mm;;padding-top:3mm;">
							Enter the smaller of line 6b or line 6c
							<span class="sty7211DotLn">......................</span>
						</div>
						<div class="styLNRightNumBox" style="height:7mm;">
							<br/>6d</div>
						<div class="styLNAmountBox" style="height:7mm;width:29mm;">
							<br/>
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/SmllrCrBfrReductionFncPctAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Line 7-->
					<div class="styStdDiv">
						<div class="styLNLeftNumBox" style="padding-top:3mm;">7</div>
						<div class="styLNDesc" style="height:auto;width:142mm;padding-top:3mm;">
							Subtract line 6d from line 5b 						
							<span class="sty7211DotLn">.........................</span>
						</div>
						<div class="styLNRightNumBox" style="height:7mm;">
							<br/>7</div>
						<div class="styLNAmountBox" style="height:7mm;width:29mm;">
							<br/>
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/AdjustedCreditReductionAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Line 8a-->
					<div class="styStdDiv">
						<div class="styLNLeftNumBox">8a</div>
						<div class="styLNDesc" style="height:19mm;width:142mm;">
						Domestic content bonus credit. If: <br/>
							<b>.</b> You qualify for the domestic content bonus credit and claimed the energy community bonus credit online 5a, multiply the amount on line 7 by 0.0909091
 <br/>
							<b>.</b> You qualify for the domestic content bonus credit and did NOT claim the energy community bonus credit on line 5a, multiply the amount on line 7 by 10%(0.10).<br/>
							<b>.</b> You do not qualify for the domestic content bonus credit , enter -0-.
							<span class="sty7211DotLn">............</span>
						</div>
						<div class="styLNRightNumBox" style="height:19mm;padding-top:14mm;">						
							8a</div>
						<div class="styLNAmountBox" style="height:19mm;width:29mm;padding-top:14mm;">
					
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/DomesticContentBonusCreditAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Line 8b-->
					<div class="styStdDiv">
						<div class="styLNLeftNumBox" style="padding-left:3mm; padding-top:3mm;">b</div>
						<div class="styLNDesc" style="height:auto;width:142mm;padding-top:3mm;">
							Add lines 7 and 8a
							<span class="sty7211DotLn">............................</span>
						</div>
						<div class="styLNRightNumBox" style="height:7mm;padding-down:0mm">
							<br/>8b</div>
						<div class="styLNAmountBox" style="height:7mm;padding-down:0mm;width:29mm;">
							<br/>
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/AdjCrRedDomContentBonusAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Line 9 -->
					<div class="styStdDiv">
						<div class="styLNLeftNumBox">9</div>
						<div class="styLNDesc" style="height:20mm;width:142mm"> 
							Phase-out for elective payment. If you are making an elective payment election under section 6417, <br/>
							for a facility whose construction began in 2024 and the facility does not conform to section 45Y(g)<br/>
							(12)(B)(i) or meet the exception under section 45Y(g)(12)(B)(ii), multiply line 8b by 90% (0.90). If you <br/>
are making an elective payment election, for a facility whose construction began in 2025 and the<br/>
facility does not conform to section 45Y(g)(12)(B)(i) or meet the exception under section 45Y(g)(12)<br/>
(B)(ii), multiply line 8b by 85% (0.85). All others, enter the amount from line 8b 
							<span class="sty7211DotLn">........</span>
						</div>
						<div class="styLNRightNumBoxNBB" style="background-color:lightgrey;height:14mm"/>
						<div class="styLNAmountBoxNBB" style="height:14mm;width:29mm;"/>
						<div class="styLNRightNumBox" style="height:6mm;padding-top:2mm;width:8mm;">9</div>
						<div class="styLNAmountBox" style="height:6mm;padding-top:2mm;width:29mm;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/PhaseoutElectivePaymentPctAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Line 10 -->
					<div class="styStdDiv">
						<div class="styLNLeftNumBox">10</div>
						<div class="styLNDesc" style="height:auto;width:142mm;">
							Clean electricity production credit from partnerships and S corporations, cooperatives, estates, and <br/>
							trusts (see instructions)
							<span class="sty7211DotLn">..........................</span>
						</div>
						<div class="styLNRightNumBox" style="height:7mm;">
							<br/>10</div>
						<div class="styLNAmountBox" style="height:7mm;width:29mm;">
							<br/>
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/CleanElectricityProdCrAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Line 11 -->
					<div class="styStdDiv">
						<div class="styLNLeftNumBox">11</div>
						<div class="styLNDesc" style="height:8mm;width:142mm;">
							Add lines 9 and 10. Cooperatives, estates, and trusts, go to line 12. Partnerships, and S <br/>
							corporations not electing transfer, stop here and report this amount on Schedule K. All others, stop <br/>
						here and report this amount on Form 3800, Part III, line 1gg
							<span class="sty7211DotLn">.............</span>
						</div>
						<div class="styLNRightNumBoxNBB" style="background-color:lightgrey;height:6mm"/>
						<div class="styLNAmountBoxNBB" style="height:6mm;width:29mm;"/>
						<div class="styLNRightNumBox" style="height:4mm;padding-top:.5mm;">11</div>
						<div class="styLNAmountBox" style="height:4mm;padding-top:.5mm;width:29mm;">
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/TotalAllowedTaxCreditAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Line 12 -->
					<div class="styStdDiv">
						<div class="styLNLeftNumBox">12</div>
						<div class="styLNDesc" style="height:auto;width:142mm;">
Amount allocated to patrons of the cooperative or beneficiaries of the estate or trust (see<br/>
instructions)
						<span class="sty7211DotLn">.............................</span>
						</div>
						<div class="styLNRightNumBox" style="height:7mm;">
							<br/>12</div>
						<div class="styLNAmountBox" style="height:7mm;width:29mm;">
							<br/>
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/AllocatedToBeneficiariesAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<!-- Line 13 -->
					<div class="styStdDiv">
						<div class="styLNLeftNumBox">13</div>
						<div class="styLNDesc" style="height:auto;width:142mm;">
						Cooperatives, estates, and trusts, subtract line 12 from line 11. Report this amount on Form 3800,<br/>
Part III, line 1gg
							<span class="sty7211DotLn">............................</span>
						</div>
						<div class="styLNRightNumBox" style="height:7mm;">
							<br/>13</div>
						<div class="styLNAmountBox" style="height:7mm;width:29mm;">
							<br/>
							<xsl:call-template name="PopulateAmount">
								<xsl:with-param name="TargetNode" select="$FormData/EstatesTrustsAndCoopsCreditAmt"/>
							</xsl:call-template>
						</div>
					</div>
					<div class="styStdDiv pageEnd" style="border-top:1px solid black;">
						<span style="font-weight:bold;font-family:Arial;"/>
						<span style="margin-left:20mm;"/>
						<span style="float:right;">Form <strong>7211</strong> (12-2024)</span>
					</div>
					<!-- Additonal Data Title Bar and Button -->
					<div class="styLeftOverTitleLine" id="LeftoverData">
						<div class="styLeftOverTitle">
						   Additional Data        
						</div>
						<div class="styLeftOverButtonContainer">
							<input class="styLeftoverTableBtn" type="button" TabIndex="-1" value="Return to Form" onclick="javascript:returnToWriteInImage();"/>
						</div>
					</div>
					<!-- Additional Data Table -->
					<table class="styLeftOverTbl">
						<xsl:call-template name="PopulateCommonLeftover">
							<xsl:with-param name="TargetNode" select="$FormData"/>
							<xsl:with-param name="DescWidth" select="100"/>
						</xsl:call-template>
					</table>
					<br/>
				</form>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>